/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionVariablesTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testTreeCompactionWithLocalVariableOnConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Execution subProcessConcurrentExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(((ExecutionEntity)innerTaskExecution).getParentId()).singleResult();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariableLocal(subProcessConcurrentExecution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"foo", (Object)variable.getName());
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ExecutionVariablesTest.testTreeCompactionWithLocalVariableOnConcurrentExecution.bpmn20.xml"})
    @Test
    public void testStableVariableInstanceIdsOnCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Execution subProcessConcurrentExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(((ExecutionEntity)innerTaskExecution).getParentId()).singleResult();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariableLocal(subProcessConcurrentExecution.getId(), "foo", (Object)"bar");
        VariableInstance variableBeforeCompaction = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        this.taskService.complete(task.getId());
        VariableInstance variableAfterCompaction = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variableBeforeCompaction.getId(), (Object)variableAfterCompaction.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ExecutionVariablesTest.testTreeCompactionForkParallelGateway.bpmn20.xml"})
    @Test
    public void testStableVariableInstanceIdsOnCompactionAndExpansion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "foo", (Object)"bar");
        VariableInstance variableBeforeCompaction = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        this.taskService.complete(task2.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        VariableInstance variableAfterCompaction = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variableBeforeCompaction.getId(), (Object)variableAfterCompaction.getId());
    }

    @Deployment
    @Test
    public void testTreeCompactionForkParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"foo", (Object)variable.getName());
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testTreeCompactionNestedForkParallelGateway() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        String subProcessScopeExecutionId = ((ExecutionEntity)task2Execution).getParentId();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"foo", (Object)variable.getName());
        Assert.assertEquals((Object)subProcessScopeExecutionId, (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ExecutionVariablesTest.testTreeCompactionForkParallelGateway.bpmn20.xml"})
    @Test
    public void testTreeCompactionWithVariablesOnScopeAndConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "foo", (Object)"baz");
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"foo", (Object)variable.getName());
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testForkWithThreeBranchesAndJoinOfTwoBranchesParallelGateway() {
        this.runtimeService.startProcessInstanceByKey("process");
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testForkWithThreeBranchesAndJoinOfTwoBranchesInclusiveGateway() {
        this.runtimeService.startProcessInstanceByKey("process");
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ExecutionVariablesTest.testTreeCompactionForkParallelGateway.bpmn20.xml"})
    @Test
    public void testTreeCompactionAndExpansionWithConcurrentLocalVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)"value");
        this.taskService.complete(task2.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)task1.getExecutionId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ExecutionVariablesTest.testTreeCompactionForkParallelGateway.bpmn20.xml"})
    @Test
    public void testTreeCompactionAndExpansionWithScopeExecutionVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        this.runtimeService.setVariableLocal(processInstance.getId(), "var", (Object)"value");
        this.taskService.complete(task2.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getExecutionId());
    }
}

