/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.impl.variable.serializer.JavaObjectSerializer;
import org.eximeebpms.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.variables.JavaSerializable;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.TypedValueAssert;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.SerializationDataFormat;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JavaSerializationProhibitedTest {
    protected static final String ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";
    protected static final String JAVA_DATA_FORMAT = Variables.SerializationDataFormats.JAVA.getName();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private TaskService taskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        ((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getVariableSerializers().addSerializer((TypedValueSerializer)new JavaCustomSerializer());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObject() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializable value = (JavaSerializable)this.runtimeService.getVariable(instance.getId(), "simpleBean");
        Assert.assertEquals((Object)javaSerializable, (Object)value);
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "simpleBean");
        TypedValueAssert.assertObjectValueDeserialized(typedValue, javaSerializable);
        TypedValueAssert.assertObjectValueSerializedJava(typedValue, javaSerializable);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectSerialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot set variable with name simpleBean. Java serialization format is prohibited");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectSerializedEmptySerializationDataFormat() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.serializedObjectValue((String)serializedObject).objectTypeName(JavaSerializable.class.getName()).create())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot set variable with name simpleBean. Java serialization format is prohibited");
    }

    @Test
    public void testStandaloneTaskTransientVariableSerializedObject() {
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.setVariable(taskId, "instrument", (Object)Variables.serializedObjectValue((String)"any value").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).setTransient(true).create())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot set variable with name instrument. Java serialization format is prohibited");
        }
        finally {
            this.taskService.deleteTask(taskId, true);
        }
    }

    private class JavaCustomSerializer
    extends JavaObjectSerializer {
        private JavaCustomSerializer() {
        }

        protected boolean canWriteValue(TypedValue typedValue) {
            return true;
        }
    }
}

