/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.async;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.bpmn.async.RetryCmdDeployment;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FoxJobRetryCmdEventsTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public RetryCmdDeployment deployment;
    private Deployment currentDeployment;

    @Parameterized.Parameters(name="deployment {index}")
    public static Collection<RetryCmdDeployment[]> scenarios() {
        return RetryCmdDeployment.asParameters(RetryCmdDeployment.deployment().withEventProcess(RetryCmdDeployment.prepareSignalEventProcess()), RetryCmdDeployment.deployment().withEventProcess(RetryCmdDeployment.prepareMessageEventProcess()), RetryCmdDeployment.deployment().withEventProcess(RetryCmdDeployment.prepareEscalationEventProcess()), RetryCmdDeployment.deployment().withEventProcess(RetryCmdDeployment.prepareCompensationEventProcess()));
    }

    @Before
    public void setUp() {
        this.currentDeployment = this.testRule.deploy(this.deployment.getBpmnModelInstances());
    }

    @Test
    public void testFailedIntermediateThrowingSignalEventAsync() {
        ProcessInstance pi = this.engineRule.getRuntimeService().startProcessInstanceByKey("failedIntermediateThrowingEventAsync");
        this.assertJobRetries(pi);
    }

    @After
    public void tearDown() {
        this.engineRule.getRepositoryService().deleteDeployment(this.currentDeployment.getId(), true, true);
    }

    protected void assertJobRetries(ProcessInstance pi) {
        Assertions.assertThat((Object)pi).isNotNull();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        try {
            this.engineRule.getManagementService().executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = this.fetchJob(pi.getProcessInstanceId());
        Assertions.assertThat((int)job.getRetries()).isEqualTo(4);
    }

    protected Job fetchJob(String processInstanceId) {
        return (Job)this.engineRule.getManagementService().createJobQuery().processInstanceId(processInstanceId).singleResult();
    }
}

