/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.authorization;

import java.util.List;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.GroupQuery;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.identity.UserQuery;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.IdentityLink;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class StartAuthorizationTest
extends PluggableProcessEngineTest {
    IdentityService identityService;
    User userInGroup1;
    User userInGroup2;
    User userInGroup3;
    Group group1;
    Group group2;
    Group group3;

    protected void setUpUsersAndGroups() throws Exception {
        this.identityService = this.processEngine.getIdentityService();
        this.identityService.saveUser(this.identityService.newUser("user1"));
        this.identityService.saveUser(this.identityService.newUser("user2"));
        this.identityService.saveUser(this.identityService.newUser("user3"));
        this.userInGroup1 = this.identityService.newUser("userInGroup1");
        this.identityService.saveUser(this.userInGroup1);
        this.userInGroup2 = this.identityService.newUser("userInGroup2");
        this.identityService.saveUser(this.userInGroup2);
        this.userInGroup3 = this.identityService.newUser("userInGroup3");
        this.identityService.saveUser(this.userInGroup3);
        this.group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(this.group1);
        this.group2 = this.identityService.newGroup("group2");
        this.identityService.saveGroup(this.group2);
        this.group3 = this.identityService.newGroup("group3");
        this.identityService.saveGroup(this.group3);
        this.identityService.createMembership(this.userInGroup1.getId(), this.group1.getId());
        this.identityService.createMembership(this.userInGroup2.getId(), this.group2.getId());
        this.identityService.createMembership(this.userInGroup3.getId(), this.group3.getId());
    }

    protected void tearDownUsersAndGroups() throws Exception {
        this.identityService.deleteMembership(this.userInGroup1.getId(), this.group1.getId());
        this.identityService.deleteMembership(this.userInGroup2.getId(), this.group2.getId());
        this.identityService.deleteMembership(this.userInGroup3.getId(), this.group3.getId());
        this.identityService.deleteGroup(this.group1.getId());
        this.identityService.deleteGroup(this.group2.getId());
        this.identityService.deleteGroup(this.group3.getId());
        this.identityService.deleteUser(this.userInGroup1.getId());
        this.identityService.deleteUser(this.userInGroup2.getId());
        this.identityService.deleteUser(this.userInGroup3.getId());
        this.identityService.deleteUser("user1");
        this.identityService.deleteUser("user2");
        this.identityService.deleteUser("user3");
    }

    @Deployment
    @Test
    public void testIdentityLinks() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
            Assert.assertNotNull((Object)latestProcessDef);
            List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)0L, (long)links.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            Assert.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)2L, (long)links.size());
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup("user1", null, links));
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup("user2", null, links));
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process3").singleResult();
            Assert.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)1L, (long)links.size());
            Assert.assertEquals((Object)"user1", (Object)((IdentityLink)links.get(0)).getUserId());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process4").singleResult();
            Assert.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)4L, (long)links.size());
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup("userInGroup2", null, links));
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup(null, "group1", links));
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup(null, "group2", links));
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup(null, "group3", links));
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    @Deployment
    @Test
    public void testAddAndRemoveIdentityLinks() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("potentialStarterNoDefinition").singleResult();
            Assert.assertNotNull((Object)latestProcessDef);
            List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)0L, (long)links.size());
            this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), "group1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)1L, (long)links.size());
            Assert.assertEquals((Object)"group1", (Object)((IdentityLink)links.get(0)).getGroupId());
            this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), "user1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)2L, (long)links.size());
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup(null, "group1", links));
            Assert.assertEquals((Object)true, (Object)this.containsUserOrGroup("user1", null, links));
            this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), "nonexisting");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)2L, (long)links.size());
            this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), "group1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)1L, (long)links.size());
            Assert.assertEquals((Object)"user1", (Object)((IdentityLink)links.get(0)).getUserId());
            this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), "user1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            Assert.assertEquals((long)0L, (long)links.size());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    private boolean containsUserOrGroup(String userId, String groupId, List<IdentityLink> links) {
        boolean found = false;
        for (IdentityLink identityLink : links) {
            if (userId != null && userId.equals(identityLink.getUserId())) {
                found = true;
                break;
            }
            if (groupId == null || !groupId.equals(identityLink.getGroupId())) continue;
            found = true;
            break;
        }
        return found;
    }

    @Deployment
    @Test
    public void testPotentialStarter() throws Exception {
        this.setUpUsersAndGroups();
        try {
            this.identityService.setAuthenticatedUserId("unauthorizedUser");
            try {
                this.runtimeService.startProcessInstanceByKey("potentialStarter");
            }
            catch (Exception e) {
                Assert.fail((String)("No StartAuthorizationException expected, " + e.getClass().getName() + " caught."));
            }
            this.identityService.setAuthenticatedUserId("user1");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("potentialStarter");
            this.testRule.assertProcessEnded(processInstance.getId());
            Assert.assertTrue((boolean)processInstance.isEnded());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    @Deployment
    @Test
    public void testPotentialStarterNoDefinition() throws Exception {
        this.identityService = this.processEngine.getIdentityService();
        this.identityService.setAuthenticatedUserId("someOneFromMars");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("potentialStarterNoDefinition");
        Assert.assertNotNull((Object)processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    @Test
    public void testProcessDefinitionList() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
            List authorizedUsers = this.identityService.createUserQuery().potentialStarter(latestProcessDef.getId()).list();
            Assert.assertEquals((long)0L, (long)authorizedUsers.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            authorizedUsers = ((UserQuery)this.identityService.createUserQuery().potentialStarter(latestProcessDef.getId()).orderByUserId().asc()).list();
            Assert.assertEquals((long)2L, (long)authorizedUsers.size());
            Assert.assertEquals((Object)"user1", (Object)((User)authorizedUsers.get(0)).getId());
            Assert.assertEquals((Object)"user2", (Object)((User)authorizedUsers.get(1)).getId());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            List authorizedGroups = this.identityService.createGroupQuery().potentialStarter(latestProcessDef.getId()).list();
            Assert.assertEquals((long)0L, (long)authorizedGroups.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process4").singleResult();
            authorizedGroups = ((GroupQuery)this.identityService.createGroupQuery().potentialStarter(latestProcessDef.getId()).orderByGroupId().asc()).list();
            Assert.assertEquals((long)3L, (long)authorizedGroups.size());
            Assert.assertEquals((Object)"group1", (Object)((Group)authorizedGroups.get(0)).getId());
            Assert.assertEquals((Object)"group2", (Object)((Group)authorizedGroups.get(1)).getId());
            Assert.assertEquals((Object)"group3", (Object)((Group)authorizedGroups.get(2)).getId());
            List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).list();
            Assert.assertEquals((long)4L, (long)processDefinitions.size());
            Assert.assertEquals((Object)"process1", (Object)((ProcessDefinition)processDefinitions.get(0)).getKey());
            Assert.assertEquals((Object)"process2", (Object)((ProcessDefinition)processDefinitions.get(1)).getKey());
            Assert.assertEquals((Object)"process3", (Object)((ProcessDefinition)processDefinitions.get(2)).getKey());
            Assert.assertEquals((Object)"process4", (Object)((ProcessDefinition)processDefinitions.get(3)).getKey());
            processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).startableByUser("user1").list();
            Assert.assertEquals((long)2L, (long)processDefinitions.size());
            Assert.assertEquals((Object)"process2", (Object)((ProcessDefinition)processDefinitions.get(0)).getKey());
            Assert.assertEquals((Object)"process3", (Object)((ProcessDefinition)processDefinitions.get(1)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("user2").list();
            Assert.assertEquals((long)1L, (long)processDefinitions.size());
            Assert.assertEquals((Object)"process2", (Object)((ProcessDefinition)processDefinitions.get(0)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("user4").list();
            Assert.assertEquals((long)0L, (long)processDefinitions.size());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("userInGroup3").list();
            Assert.assertEquals((long)1L, (long)processDefinitions.size());
            Assert.assertEquals((Object)"process4", (Object)((ProcessDefinition)processDefinitions.get(0)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("userInGroup2").list();
            Assert.assertEquals((long)1L, (long)processDefinitions.size());
            Assert.assertEquals((Object)"process4", (Object)((ProcessDefinition)processDefinitions.get(0)).getKey());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }
}

