/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.common;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineServices;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.instance.Task;
import org.eximeebpms.bpm.model.xml.instance.ModelElementInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractProcessEngineServicesAccessTest
extends PluggableProcessEngineTest {
    private static final String TASK_DEF_KEY = "someTask";
    private static final String PROCESS_DEF_KEY = "testProcess";
    private static final String CALLED_PROCESS_DEF_ID = "calledProcess";
    protected List<String> deploymentIds = new ArrayList<String>();

    @After
    public void tearDown() throws Exception {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    @Test
    public void testServicesAccessible() {
        this.createAndDeployModelForClass(this.getTestServiceAccessibleClass());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
    }

    @Test
    public void testQueryAccessible() {
        this.createAndDeployModelForClass(this.getQueryClass());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
    }

    @Test
    public void testStartProcessInstance() {
        this.createAndDeployModelForClass(this.getStartProcessInstanceClass());
        this.assertStartProcessInstance();
    }

    @Test
    public void testStartProcessInstanceFails() {
        this.createAndDeployModelForClass(this.getStartProcessInstanceClass());
        this.assertStartProcessInstanceFails();
    }

    @Test
    public void testProcessEngineStartProcessInstance() {
        this.createAndDeployModelForClass(this.getProcessEngineStartProcessClass());
        this.assertStartProcessInstance();
    }

    protected void assertStartProcessInstanceFails() {
        BpmnModelInstance modelInstance = ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)CALLED_PROCESS_DEF_ID).startEvent().scriptTask("scriptTask").scriptFormat("groovy")).scriptText("throw new RuntimeException(\"BOOOM!\")")).endEvent().done();
        this.deployModel(modelInstance);
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("BOOOM", e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    protected abstract Class<?> getTestServiceAccessibleClass();

    protected abstract Class<?> getQueryClass();

    protected abstract Class<?> getStartProcessInstanceClass();

    protected abstract Class<?> getProcessEngineStartProcessClass();

    protected abstract Task createModelAccessTask(BpmnModelInstance var1, Class<?> var2);

    private void createAndDeployModelForClass(Class<?> delegateClass) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)PROCESS_DEF_KEY).startEvent().manualTask("templateTask").endEvent().done();
        modelInstance.getModelElementById("templateTask").replaceWithElement((ModelElementInstance)this.createModelAccessTask(modelInstance, delegateClass));
        this.deployModel(modelInstance);
    }

    private void deployModel(BpmnModelInstance model) {
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", model).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    protected void assertStartProcessInstance() {
        this.deployModel(Bpmn.createExecutableProcess((String)CALLED_PROCESS_DEF_ID).startEvent().userTask(TASK_DEF_KEY).endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEF_KEY);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey(TASK_DEF_KEY).count());
    }

    @Test
    public void testProcessEngineStartProcessInstanceFails() {
        this.createAndDeployModelForClass(this.getProcessEngineStartProcessClass());
        this.assertStartProcessInstanceFails();
    }

    public static void assertCanAccessServices(ProcessEngineServices services) {
        Assert.assertNotNull((Object)services.getAuthorizationService());
        Assert.assertNotNull((Object)services.getFormService());
        Assert.assertNotNull((Object)services.getHistoryService());
        Assert.assertNotNull((Object)services.getIdentityService());
        Assert.assertNotNull((Object)services.getManagementService());
        Assert.assertNotNull((Object)services.getRepositoryService());
        Assert.assertNotNull((Object)services.getRuntimeService());
        Assert.assertNotNull((Object)services.getTaskService());
    }

    public static void assertCanPerformQuery(ProcessEngineServices services) {
        services.getRepositoryService().createProcessDefinitionQuery().count();
    }

    public static void assertCanStartProcessInstance(ProcessEngineServices services) {
        services.getRuntimeService().startProcessInstanceByKey(CALLED_PROCESS_DEF_ID);
    }

    public static void assertCanStartProcessInstance(ProcessEngine processEngine) {
        processEngine.getRuntimeService().startProcessInstanceByKey(CALLED_PROCESS_DEF_ID);
    }
}

