/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.conditional;

import java.util.Arrays;
import java.util.Collection;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.eximeebpms.bpm.engine.test.bpmn.event.conditional.SetMultipleSameVariableDelegate;
import org.eximeebpms.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.eximeebpms.bpm.model.bpmn.instance.SequenceFlow;
import org.eximeebpms.bpm.model.bpmn.instance.eximeebpms.CamundaExecutionListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TriggerConditionalEventFromDelegationCodeTest
extends AbstractConditionalEventTestCase {
    @Parameterized.Parameter
    public ConditionalEventProcessSpecifier specifier;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new ConditionalEventProcessSpecifier(){

            @Override
            public Class getDelegateClass() {
                return SetVariableDelegate.class;
            }

            @Override
            public int getExpectedInterruptingCount() {
                return 1;
            }

            @Override
            public int getExpectedNonInterruptingCount() {
                return 1;
            }

            @Override
            public String getCondition() {
                return "${variable == 1}";
            }

            public String toString() {
                return "SetSingleVariableInDelegate";
            }
        }}, {new ConditionalEventProcessSpecifier(){

            @Override
            public Class getDelegateClass() {
                return SetMultipleSameVariableDelegate.class;
            }

            @Override
            public int getExpectedInterruptingCount() {
                return 1;
            }

            @Override
            public int getExpectedNonInterruptingCount() {
                return 3;
            }

            @Override
            public String getCondition() {
                return "${variable2 == 1}";
            }

            public String toString() {
                return "SetMultipleVariableInDelegate";
            }
        }});
    }

    @Test
    public void testSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaExecutionListenerClass("start", this.specifier.getDelegateClass().getName())).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.getExpectedInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testNonInterruptingSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaExecutionListenerClass("start", this.specifier.getDelegateClass().getName())).name("Task with condition")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)(1 + this.specifier.getExpectedNonInterruptingCount()), (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)this.specifier.getExpectedNonInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(this.specifier.getDelegateClass().getName());
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.getExpectedInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testNonInterruptingSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(this.specifier.getDelegateClass().getName());
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)(1 + this.specifier.getExpectedNonInterruptingCount()), (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)this.specifier.getExpectedNonInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testSetVariableInTakeListenerWithAsyncBefore() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").camundaAsyncBefore()).endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(this.specifier.getDelegateClass().getName());
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.getExpectedInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testNonInterruptingSetVariableInTakeListenerWithAsyncBefore() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").camundaAsyncBefore()).endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(this.specifier.getDelegateClass().getName());
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        Assert.assertEquals((long)this.specifier.getExpectedNonInterruptingCount(), (long)this.taskService.createTaskQuery().taskName("After Condition").count());
        Job job = (Job)this.engine.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.engine.getManagementService().executeJob(job.getId());
        Assert.assertEquals((long)(this.specifier.getExpectedNonInterruptingCount() + 1), (long)taskQuery.count());
        for (Task task : taskQuery.list()) {
            this.taskService.complete(task.getId());
        }
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerClass("end", this.specifier.getDelegateClass().getName())).userTask("taskWithCondition").endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.getExpectedInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testNonInterruptingSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerClass("end", this.specifier.getDelegateClass().getName())).userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)(1 + this.specifier.getExpectedNonInterruptingCount()), (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)this.specifier.getExpectedNonInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    @Test
    public void testSetVariableInStartAndEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerClass("start", this.specifier.getDelegateClass().getName())).camundaExecutionListenerClass("end", this.specifier.getDelegateClass().getName())).userTask("taskWithCondition").endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", this.specifier.getCondition(), true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.getExpectedInterruptingCount(), (long)taskQuery.taskName("After Condition").count());
    }

    private static interface ConditionalEventProcessSpecifier {
        public Class getDelegateClass();

        public int getExpectedInterruptingCount();

        public int getExpectedNonInterruptingCount();

        public String getCondition();
    }
}

