/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.error;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.delegate.BpmnError;
import org.junit.Test;

public class BpmnErrorTest {
    private static final String ERROR_CODE = "testErrorCode";
    private static final String ERROR_MESSAGE = "testErrorMessage";
    private static final Throwable CAUSE = new IllegalArgumentException("causeMessage");

    @Test
    public void testCreation_ErrorCodeOnly() {
        BpmnError bpmnError = new BpmnError(ERROR_CODE);
        Assertions.assertThat((Throwable)bpmnError).hasMessage(null);
        Assertions.assertThat((String)bpmnError.getErrorCode()).isEqualTo((Object)ERROR_CODE);
    }

    @Test
    public void testCreation_ErrorMessagePresent() {
        BpmnError bpmnError = new BpmnError(ERROR_CODE, ERROR_MESSAGE);
        Assertions.assertThat((Throwable)bpmnError).hasMessage(ERROR_MESSAGE);
        Assertions.assertThat((String)bpmnError.getErrorCode()).isEqualTo((Object)ERROR_CODE);
    }

    @Test
    public void testCreation_ErrorCodeOnlyWithCause() {
        BpmnError bpmnError = new BpmnError(ERROR_CODE, CAUSE);
        Assertions.assertThat((Throwable)bpmnError).hasMessage(null).hasCause(CAUSE);
        Assertions.assertThat((String)bpmnError.getErrorCode()).isEqualTo((Object)ERROR_CODE);
    }

    @Test
    public void testCreation_ErrorMessageAndCausePresent() {
        BpmnError bpmnError = new BpmnError(ERROR_CODE, ERROR_MESSAGE, CAUSE);
        Assertions.assertThat((Throwable)bpmnError).hasMessageContaining(ERROR_MESSAGE).hasCause(CAUSE);
        Assertions.assertThat((String)bpmnError.getErrorCode()).isEqualTo((Object)ERROR_CODE);
    }
}

