/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.error;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ErrorEndEventTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/error/testPropagateOutputVariablesWhileThrowError.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/error/ErrorEventTest.errorParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowError() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("ErrorParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched error").count());
        Assert.assertNotNull((Object)this.runtimeService.getVariable(processInstanceId, "cancelReason"));
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Test
    @Deployment
    public void testErrorMessage() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testErrorMessage");
        Map variables = this.runtimeService.getVariables(instance.getId());
        Assertions.assertThat((String)((String)variables.get("errorCode"))).isEqualTo((Object)"123");
        Assertions.assertThat((String)((String)variables.get("errorMessage"))).isEqualTo((Object)"This is the error message indicating what went wrong.");
    }

    @Test
    @Deployment
    public void testErrorMessageExpression() {
        String errorMessage = "This is the error message indicating what went wrong.";
        HashMap<String, String> initialVariables = new HashMap<String, String>();
        initialVariables.put("errorMessageExpression", errorMessage);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testErrorMessageExpression", initialVariables);
        Map variables = this.runtimeService.getVariables(instance.getId());
        Assertions.assertThat((String)((String)variables.get("errorCode"))).isEqualTo((Object)"123");
        Assertions.assertThat((String)((String)variables.get("errorMessage"))).isEqualTo((Object)errorMessage);
    }

    @Test
    @Deployment
    public void testError() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testError");
        Map variables = this.runtimeService.getVariables(instance.getId());
        Assertions.assertThat((String)((String)variables.get("errorCode"))).isEqualTo((Object)"123");
        Assert.assertNull(variables.get("errorMessage"));
    }
}

