/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.error;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.event.error.ThrowBpmnErrorDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UnhandledBpmnErrorTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setEnableExceptionsAfterUnhandledBpmnError(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void testThrownInJavaDelegate() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass(ThrowBpmnErrorDelegate.class)).endEvent().done();
        this.testRule.deploy(instance);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("process")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("no error handler");
    }

    @Test
    @Deployment
    public void testUncaughtErrorSimpleProcess() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("process")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("no error handler");
    }

    @Test
    @Deployment
    public void testUnhandledErrorInEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("boundaryErrorOnEmbeddedSubprocess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("no error handler");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/error/UnhandledBpmnErrorTest.testUncaughtErrorOnCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/error/UnhandledBpmnErrorTest.subprocess.bpmn20.xml"})
    public void testUncaughtErrorOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("uncaughtErrorOnCallActivity");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("no error handler");
    }

    @Test
    @Deployment
    public void testUncaughtErrorOnEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("no error handler");
    }
}

