/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.message;

import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionTree;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class MessageNonInterruptingBoundaryEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSingleNonInterruptingBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        Assert.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessage").singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessage").singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterMessage", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterTask").singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        Assert.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        Assert.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterTask").singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"taskAfterTask", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testNonInterruptingEventInCombinationWithReceiveTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task2Execution).getParentId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingEventInCombinationWithReceiveTaskInConcurrentSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Task afterFork = (Task)this.taskService.createTaskQuery().taskDefinitionKey("afterFork").singleResult();
        this.taskService.complete(afterFork.getId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task2Execution).getParentId());
        this.taskService.complete(task2.getId());
        this.taskService.complete(task1.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingEventInCombinationWithReceiveTaskInsideSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("firstMessage");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("task1").beginScope("innerSubProcess").activity("receiveTask").done());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingEventInCombinationWithUserTaskInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").noScope().concurrent().up().child(null).noScope().concurrent().child("innerTask").scope().done());
        this.taskService.complete(innerTask.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingEventInCombinationWithUserTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child(null).noScope().concurrent().child("innerTask").scope().done());
        this.taskService.complete(innerTask.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingWithUserTaskAndBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        this.taskService.complete(task2.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("tasks").singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNestedEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("thirdMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)task2Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task2Execution).getParentId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/message/MessageNonInterruptingBoundaryEventTest.testNestedEvents.bpmn20.xml"})
    @Test
    public void testNestedEventsAnotherExecutionOrder() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        Assert.assertNotNull((Object)innerTask);
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("thirdMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)task2Execution);
        Assert.assertEquals((Object)processInstanceId, (Object)((ExecutionEntity)task2Execution).getParentId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }
}

