/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.signal;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.event.EventType;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SignalEventDeploymentTest
extends PluggableProcessEngineTest {
    private static final String SIGNAL_START_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml";
    private static final String SIGNAL_START_EVENT_PROCESS_NEW_VERSION = "org/eximeebpms/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent_v2.bpmn20.xml";

    @Test
    public void testCreateEventSubscriptionOnDeployment() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS));
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)eventSubscription);
        Assert.assertEquals((Object)EventType.SIGNAL.name(), (Object)eventSubscription.getEventType());
        Assert.assertEquals((Object)"alert", (Object)eventSubscription.getEventName());
        Assert.assertEquals((Object)"start", (Object)eventSubscription.getActivityId());
    }

    @Test
    public void testUpdateEventSubscriptionOnDeployment() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS));
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventType("signal").singleResult();
        Assert.assertNotNull((Object)eventSubscription);
        Assert.assertEquals((Object)"alert", (Object)eventSubscription.getEventName());
        String newDeploymentId = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS_NEW_VERSION).deploy().getId();
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult();
        Assert.assertEquals((long)2L, (long)newProcessDefinition.getVersion());
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("signal").list();
        Assert.assertEquals((long)1L, (long)newEventSubscriptions.size());
        EventSubscriptionEntity newEventSubscription = (EventSubscriptionEntity)newEventSubscriptions.iterator().next();
        Assert.assertEquals((Object)newProcessDefinition.getId(), (Object)newEventSubscription.getConfiguration());
        Assert.assertEquals((Object)"abort", (Object)newEventSubscription.getEventName());
        this.repositoryService.deleteDeployment(newDeploymentId);
    }

    @Test
    public void testAsyncSignalStartEventDeleteDeploymentWhileAsync() {
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(SIGNAL_START_EVENT_PROCESS).addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().count());
        }
    }
}

