/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.timer;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;

public class BoundaryTimerEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testMultipleTimersOnUserTask() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleTimersOnUserTask");
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)3L, (long)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Third Task", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testTimerOnNestingOfSubprocesses() {
        this.runtimeService.startProcessInstanceByKey("timerOnNestedSubprocesses");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Inner subprocess task 1", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Inner subprocess task 2", (Object)((Task)tasks.get(1)).getName());
        Job timer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(timer.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task outside subprocess", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testExpressionOnTimer() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duration", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testRecalculateUnchangedExpressionOnTimerCurrentDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        Date currentTime = new Date(startTime.getTime() + TimeUnit.MINUTES.toMillis(5L));
        ClockUtil.setCurrentTime((Date)currentTime);
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDate.before(jobUpdated.getDuedate()));
        Date expectedDate = LocalDateTime.fromDateFields((Date)currentTime).plusHours(1).toDate();
        Assertions.assertThat((Date)jobUpdated.getDuedate()).isCloseTo(expectedDate, 1000L);
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(1L) + TimeUnit.MINUTES.toMillis(6L)));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    @Test
    public void testRecalculateUnchangedExpressionOnTimerCreationDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.SECONDS.toMillis(5L)));
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Date expectedDate = LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusHours(1).toDate();
        Assert.assertEquals((Object)expectedDate, (Object)jobUpdated.getDuedate());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(1L) + TimeUnit.SECONDS.toMillis(15L)));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    @Test
    public void testRecalculateChangedExpressionOnTimerCurrentDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        ClockUtil.offset((Long)2000L);
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDate.before(jobUpdated.getDuedate()));
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.HOURS.toMillis(2L)));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/BoundaryTimerEventTest.testRecalculateUnchangedExpressionOnTimerCurrentDateBased.bpmn20.xml"})
    @Test
    public void testRecalculateChangedExpressionOnTimerCreationDateBased() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duedate", "PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExpressionOnTimer", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        this.runtimeService.setVariable(pi.getId(), "duedate", (Object)"PT15M");
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertEquals((Object)LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(15).toDate(), (Object)jobUpdated.getDuedate());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + TimeUnit.MINUTES.toMillis(16L)));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimerInSingleTransactionProcess() {
        this.runtimeService.startProcessInstanceByKey("timerOnSubprocesses");
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    @Test
    public void testRepeatingTimerWithCancelActivity() {
        this.runtimeService.startProcessInstanceByKey("repeatingTimerAndCallActivity");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlows() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlowsOnSubprocess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlowsOnSubprocessMi() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("interruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testInterruptingTimerDuration() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("escalationExample");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"First line support", (Object)task.getName());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Handle escalated issue", (Object)task.getName());
    }
}

