/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class TimeExpressionTest
extends PluggableProcessEngineTest {
    private Date testExpression(String timeExpression) {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("dueDate", timeExpression);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        List jobs = this.managementService.createJobQuery().executable().list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        return ((Job)jobs.get(0)).getDuedate();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionComplete() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dt));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dt), (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dueDate));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionWithoutSeconds() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dt));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dt), (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dueDate));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionWithoutMinutes() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH").format(new Date()));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH").format(dt), (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH").format(dueDate));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionWithoutTime() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").format(dt), (Object)new SimpleDateFormat("yyyy-MM-dd").format(dueDate));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionWithoutDay() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM").format(new Date()));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM").format(dt), (Object)new SimpleDateFormat("yyyy-MM").format(dueDate));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    @Test
    public void testTimeExpressionWithoutMonth() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy").format(new Date()));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy").format(dt), (Object)new SimpleDateFormat("yyyy").format(dueDate));
    }
}

