/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.executionlistener;

import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.test.bpmn.common.AbstractProcessEngineServicesAccessTest;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.eximeebpms.bpm.model.bpmn.instance.ManualTask;
import org.eximeebpms.bpm.model.bpmn.instance.Task;
import org.eximeebpms.bpm.model.bpmn.instance.eximeebpms.CamundaExecutionListener;

public class ListenerProcessEngineServicesAccessTest
extends AbstractProcessEngineServicesAccessTest {
    @Override
    protected Class<?> getTestServiceAccessibleClass() {
        return AccessServicesListener.class;
    }

    @Override
    protected Class<?> getQueryClass() {
        return PerformQueryListener.class;
    }

    @Override
    protected Class<?> getStartProcessInstanceClass() {
        return StartProcessListener.class;
    }

    @Override
    protected Class<?> getProcessEngineStartProcessClass() {
        return ProcessEngineStartProcessListener.class;
    }

    @Override
    protected Task createModelAccessTask(BpmnModelInstance modelInstance, Class<?> delegateClass) {
        ManualTask task = (ManualTask)modelInstance.newInstance(ManualTask.class);
        task.setId("manualTask");
        CamundaExecutionListener executionListener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        executionListener.setCamundaEvent("start");
        executionListener.setCamundaClass(delegateClass.getName());
        task.builder().addExtensionElement((BpmnModelElementInstance)executionListener);
        return task;
    }

    public static class AccessServicesListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanAccessServices(execution.getProcessEngineServices());
        }
    }

    public static class PerformQueryListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanPerformQuery(execution.getProcessEngineServices());
        }
    }

    public static class StartProcessListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngineServices());
        }
    }

    public static class ProcessEngineStartProcessListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngine());
        }
    }
}

