/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.external;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTaskParseTest
extends PluggableProcessEngineTest {
    @Test
    public void testParseExternalTaskWithoutTopic() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/external/ExternalTaskParseTest.testParseExternalTaskWithoutTopic.bpmn20.xml");
        try {
            deploymentBuilder.deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("External tasks must specify a 'topic' attribute in the camunda namespace", e.getMessage());
            Assertions.assertThat((int)((ResourceReport)e.getResorceReports().get(0)).getErrors().size()).isEqualTo(1);
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"externalTask");
        }
    }

    @Deployment
    @Test
    public void testParseExternalTaskWithExpressionTopic() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("topicName", "testTopicExpression");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithExpressionTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((String)"testTopicExpression").isEqualTo((Object)task.getTopicName());
    }

    @Deployment
    @Test
    public void testParseExternalTaskWithStringTopic() {
        HashMap variables = new HashMap();
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithStringTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((String)"testTopicString").isEqualTo((Object)task.getTopicName());
    }
}

