/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.gateway;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.bpmn.iomapping.VariableLogDelegate;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class EventBasedGatewayInputOutputTest
extends PluggableProcessEngineTest {
    protected static final BpmnModelInstance EVENT_GATEWAY_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ConditionalEventDefinitionBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().eventBasedGateway().intermediateCatchEvent("conditionalEvent").camundaOutputParameter("eventOutput", "foo")).conditionalEventDefinition().condition("${moveOn}")).conditionalEventDefinitionDone().serviceTask("inputParameterTask").camundaInputParameter("variable1", "testValue")).camundaClass(VariableLogDelegate.class)).endEvent().done();
    protected boolean skipOutputMappingVal;

    @Before
    public void setUp() {
        this.skipOutputMappingVal = this.processEngineConfiguration.isSkipOutputMappingOnCanceledActivities();
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(true);
        VariableLogDelegate.reset();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(this.skipOutputMappingVal);
        VariableLogDelegate.reset();
    }

    @Test
    public void shouldProcessInputOutputParametersAfterEventGateway() {
        this.testRule.deploy(EVENT_GATEWAY_PROCESS);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"moveOn", (Object)true));
        List vars = this.historyService.createHistoricVariableInstanceQuery().variableName("eventOutput").list();
        Assertions.assertThat((List)vars).hasSize(1);
        Assertions.assertThat((Object)((HistoricVariableInstance)vars.get(0)).getValue()).isEqualTo((Object)"foo");
        Assertions.assertThat(VariableLogDelegate.LOCAL_VARIABLES).hasSize(1);
        vars = this.historyService.createHistoricVariableInstanceQuery().variableName("variable1").list();
        Assertions.assertThat((List)vars).hasSize(1);
        Assertions.assertThat((Object)((HistoricVariableInstance)vars.get(0)).getValue()).isEqualTo((Object)"testValue");
    }

    @Test
    public void shouldNotProcessInputOutputParametersAfterEventGatewayDeletion() {
        this.testRule.deploy(EVENT_GATEWAY_PROCESS);
        String instanceId = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"moveOn", (Object)false)).getId();
        this.runtimeService.deleteProcessInstance(instanceId, "manual cancelation");
        Assertions.assertThat(VariableLogDelegate.LOCAL_VARIABLES).isEmpty();
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().variableName("eventOutput").count()).isEqualTo(0L);
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().variableName("variable1").count()).isEqualTo(0L);
    }
}

