/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.gateway;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.EventSubscriptionQuery;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class EventBasedGatewayTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testCatchAlertAndTimer.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.throwAlertSignal.bpmn20.xml"})
    @Test
    public void testCatchSignalCancelsTimer() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskName("afterSignal").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testCatchAlertAndTimer.bpmn20.xml"})
    @Test
    public void testCatchTimerCancelsSignal() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 10000L));
        try {
            this.testRule.waitForJobExecutorToProcessAllJobs(10000L);
            Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
            Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
            Task task = (Task)this.taskService.createTaskQuery().taskName("afterTimer").singleResult();
            Assert.assertNotNull((Object)task);
            this.taskService.complete(task.getId());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    @Test
    public void testCatchSignalAndMessageAndTimer() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        EventSubscriptionQuery messageEventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().eventType("message");
        Assert.assertEquals((long)1L, (long)messageEventSubscriptionQuery.count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoice").signalEventSubscriptionName("alert").singleResult();
        Assert.assertNotNull((Object)execution);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 10000L));
        try {
            EventSubscription messageEventSubscription = (EventSubscription)messageEventSubscriptionQuery.singleResult();
            this.runtimeService.messageEventReceived(messageEventSubscription.getEventName(), messageEventSubscription.getExecutionId());
            Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
            Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
            Task task = (Task)this.taskService.createTaskQuery().taskName("afterMessage").singleResult();
            Assert.assertNotNull((Object)task);
            this.taskService.complete(task.getId());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    @Test
    public void testConnectedToActitity() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testConnectedToActivity.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Event based gateway can only be connected to elements of type intermediateCatchEvent"));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"gw1");
        }
    }

    @Test
    public void testInvalidSequenceFlow() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testEventInvalidSequenceFlow.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid incoming sequenceflow for intermediateCatchEvent"));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"invalidFlow");
        }
    }

    @Deployment
    @Test
    public void testTimeCycle() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.assertProcessEnded(processInstanceId);
    }
}

