/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.iomapping;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.impl.calendar.DateTimeUtil;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TimerEntity;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.iomapping.VariableLogDelegate;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InputOutputEventTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        VariableLogDelegate.reset();
    }

    @Deployment
    @Test
    public void testMessageThrowEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        Assert.assertEquals((long)1L, (long)mappedVariables.size());
        Assert.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        Assert.assertEquals((Object)"mappedValue", (Object)variable);
    }

    @Deployment
    @Test
    public void testMessageCatchEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution messageExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("messageCatch").singleResult();
        Map localVariables = this.runtimeService.getVariablesLocal(messageExecution.getId());
        Assert.assertEquals((long)1L, (long)localVariables.size());
        Assert.assertEquals((Object)"mappedValue", localVariables.get("mappedVariable"));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("messageVariable", "outValue");
        this.runtimeService.messageEventReceived("IncomingMessage", messageExecution.getId(), variables);
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        Assert.assertEquals((Object)"outValue", (Object)variable);
    }

    @Deployment
    @Test
    public void testTimerCatchEvent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        Date dueDate = DateTimeUtil.now().plusMinutes(5).toDate();
        variables.put("outerVariable", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dueDate));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        TimerEntity timer = (TimerEntity)job;
        this.assertDateEquals(dueDate, timer.getDuedate());
    }

    protected void assertDateEquals(Date expected, Date actual) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Assert.assertEquals((Object)format.format(expected), (Object)format.format(actual));
    }

    @Deployment
    @Test
    public void testNoneThrowEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        Assert.assertEquals((long)1L, (long)mappedVariables.size());
        Assert.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
        String variable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outVariable");
        Assert.assertEquals((Object)"mappedValue", (Object)variable);
    }

    @Test
    public void testMessageStartEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testMessageStartEvent.bpmn20.xml").deploy();
            Assert.fail((String)"expected exception");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'startEvent'", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"start");
        }
    }

    @Test
    public void testNoneEndEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testNoneEndEvent.bpmn20.xml").deploy();
            Assert.fail((String)"expected exception");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("camunda:outputParameter not allowed for element type 'endEvent'", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"endMapping");
        }
    }

    @Deployment
    @Test
    public void testMessageEndEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Map<String, Object> mappedVariables = VariableLogDelegate.LOCAL_VARIABLES;
        Assert.assertEquals((long)1L, (long)mappedVariables.size());
        Assert.assertEquals((Object)"mappedValue", (Object)mappedVariables.get("mappedVariable"));
    }

    @Deployment
    @Test
    public void testMessageCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("foo").processInstanceId(processInstance.getId()).correlate();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    @Test
    public void testTimerCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    @Test
    public void testSignalCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).signalEventSubscriptionName("foo").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.signalEventReceived("foo", execution.getId());
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Deployment
    @Test
    public void testConditionalCatchAfterEventGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)1);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
    }

    @Test
    public void testMessageBoundaryEvent() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/iomapping/InputOutputEventTest.testMessageBoundaryEvent.bpmn20.xml").deploy();
            Assert.fail((String)"expected exception");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'boundaryEvent'", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"messageBoundary");
        }
    }

    @After
    public void tearDown() throws Exception {
        VariableLogDelegate.reset();
    }
}

