/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.job;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JobPrioritizationBpmnConstantValueTest
extends PluggableProcessEngineTest {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 0L;

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDefaultPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTaskProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDefaultPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTaskProcess").startBeforeActivity("task1")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/oneTimerProcess.bpmn20.xml"})
    @Test
    public void testDefaultPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("oneTimerProcess").startBeforeActivity("timer1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)10L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task1")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)10L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/intermediateTimerJobPrioProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("intermediateTimerJobPrioProcess").startBeforeActivity("timer1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)8L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testActivityPrioritizationAsyncBefore() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)5L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testActivityPrioritizationAsyncAfter() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)5L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/intermediateTimerJobPrioProcess.bpmn20.xml"})
    @Test
    public void testActivityPrioritizationTimer() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("intermediateTimerJobPrioProcess").startBeforeActivity("timer2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)4L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/subProcessJobPrioProcess.bpmn20.xml"})
    @Test
    public void testSubProcessPriorityIsNotDefaultForContainedActivities() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subProcessJobPrioProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)10L, (long)job.getPriority());
    }

    @Test
    public void testFailOnMalformedInput() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/job/invalidPrioProcess.bpmn20.xml").deploy();
            Assert.fail((String)"deploying a process with malformed priority should not succeed");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresentIgnoreCase("value 'thisIsNotANumber' for attribute 'jobPriority' is not a valid number", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"task2");
        }
    }

    @Test
    public void testParsePriorityOnNonAsyncActivity() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/job/JobPrioritizationBpmnTest.testParsePriorityOnNonAsyncActivity.bpmn20.xml").deploy();
        this.repositoryService.deleteDeployment(deployment.getId());
    }

    @Test
    public void testTimerStartEventPriorityOnProcessDefinition() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/job/JobPrioritizationBpmnConstantValueTest.testTimerStartEventPriorityOnProcessDefinition.bpmn20.xml").deploy();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)8L, (long)job.getPriority());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testTimerStartEventPriorityOnActivity() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/job/JobPrioritizationBpmnConstantValueTest.testTimerStartEventPriorityOnActivity.bpmn20.xml").deploy();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)1515L, (long)job.getPriority());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/boundaryTimerJobPrioProcess.bpmn20.xml"})
    @Test
    public void testBoundaryTimerEventPriority() {
        this.runtimeService.startProcessInstanceByKey("boundaryTimerJobPrioProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)20L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/eventSubprocessTimerJobPrioProcess.bpmn20.xml"})
    @Test
    public void testEventSubprocessTimerPriority() {
        this.runtimeService.startProcessInstanceByKey("eventSubprocessTimerJobPrioProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)25L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/intermediateSignalAsyncProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/job/intermediateSignalCatchJobPrioProcess.bpmn20.xml"})
    @Test
    public void testAsyncSignalThrowingEventActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("intermediateSignalCatchJobPrioProcess");
        this.runtimeService.startProcessInstanceByKey("intermediateSignalJobPrioProcess");
        Execution signal1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("signal1").singleResult();
        Job signal1Job = (Job)this.managementService.createJobQuery().executionId(signal1Execution.getId()).singleResult();
        Execution signal2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("signal2").singleResult();
        Job signal2Job = (Job)this.managementService.createJobQuery().executionId(signal2Execution.getId()).singleResult();
        Assert.assertEquals((long)8L, (long)signal1Job.getPriority());
        Assert.assertEquals((long)4L, (long)signal2Job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/intermediateSignalAsyncProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/job/signalStartJobPrioProcess.bpmn20.xml"})
    @Test
    public void testAsyncSignalThrowingEventSignalStartActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("intermediateSignalJobPrioProcess");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job signalStartJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)signalStartJob);
        Assert.assertEquals((long)4L, (long)signalStartJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/miBodyAsyncProcess.bpmn20.xml"})
    public void FAILING_testMultiInstanceBodyActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("miBodyAsyncPriorityProcess");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job miBodyJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)miBodyJob);
        Assert.assertEquals((long)5L, (long)miBodyJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/miInnerAsyncProcess.bpmn20.xml"})
    @Test
    public void testMultiInstanceInnerActivityPriority() {
        this.runtimeService.startProcessInstanceByKey("miBodyAsyncPriorityProcess");
        List jobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)3L, (long)jobs.size());
        for (Job job : jobs) {
            Assert.assertNotNull((Object)job);
            Assert.assertEquals((long)5L, (long)job.getPriority());
        }
    }
}

