/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.mail.EmailTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.subethamail.wiser.WiserMessage;

public class EmailServiceTaskTest
extends EmailTestCase {
    @Deployment
    @Test
    public void testSimpleTextMail() throws Exception {
        String procId = this.runtimeService.startProcessInstanceByKey("simpleTextOnly").getId();
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        EmailServiceTaskTest.assertEmailSend(message, false, "Hello Kermit!", "This a text only e-mail.", "eximeebpms@localhost", Arrays.asList("kermit@eximeebpms.org"), null);
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSimpleTextMailMultipleRecipients() {
        this.runtimeService.startProcessInstanceByKey("simpleTextOnlyMultipleRecipients");
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)3L, (long)messages.size());
        ArrayList<String> recipients = new ArrayList<String>();
        for (WiserMessage message : messages) {
            recipients.add(message.getEnvelopeReceiver());
        }
        Collections.sort(recipients);
        Assert.assertEquals((Object)"fozzie@eximeebpms.org", recipients.get(0));
        Assert.assertEquals((Object)"kermit@eximeebpms.org", recipients.get(1));
        Assert.assertEquals((Object)"mispiggy@eximeebpms.org", recipients.get(2));
    }

    @Deployment
    @Test
    public void testTextMailExpressions() throws Exception {
        String sender = "mispiggy@activiti.org";
        String recipient = "fozziebear@activiti.org";
        String recipientName = "Mr. Fozzie";
        String subject = "Fozzie, you should see this!";
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("sender", sender);
        vars.put("recipient", recipient);
        vars.put("recipientName", recipientName);
        vars.put("subject", subject);
        this.runtimeService.startProcessInstanceByKey("textMailExpressions", vars);
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        EmailServiceTaskTest.assertEmailSend(message, false, subject, "Hello " + recipientName + ", this is an e-mail", sender, Arrays.asList(recipient), null);
    }

    @Deployment
    @Test
    public void testCcAndBcc() throws Exception {
        this.runtimeService.startProcessInstanceByKey("ccAndBcc");
        List messages = this.wiser.getMessages();
        EmailServiceTaskTest.assertEmailSend((WiserMessage)messages.get(0), false, "Hello world", "This is the content", "eximeebpms@localhost", Arrays.asList("kermit@eximeebpms.org"), Arrays.asList("fozzie@eximeebpms.org"));
        Assert.assertEquals((long)3L, (long)messages.size());
    }

    @Deployment
    @Test
    public void testHtmlMail() throws Exception {
        this.runtimeService.startProcessInstanceByKey("htmlMail", CollectionUtil.singletonMap((String)"gender", (Object)"male"));
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        EmailServiceTaskTest.assertEmailSend((WiserMessage)messages.get(0), true, "Test", "Mr. <b>Kermit</b>", "eximeebpms@localhost", Arrays.asList("kermit@eximeebpms.org"), null);
    }

    @Deployment
    @Test
    public void testSendEmail() throws Exception {
        String from = "ordershipping@activiti.org";
        boolean male = true;
        String recipientName = "John Doe";
        String recipient = "johndoe@alfresco.com";
        Date now = new Date();
        String orderId = "123456";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("sender", from);
        vars.put("recipient", recipient);
        vars.put("recipientName", recipientName);
        vars.put("male", male);
        vars.put("now", now);
        vars.put("orderId", orderId);
        this.runtimeService.startProcessInstanceByKey("sendMailExample", vars);
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        MimeMessage mimeMessage = message.getMimeMessage();
        Assert.assertEquals((Object)("Your order " + orderId + " has been shipped"), (Object)mimeMessage.getHeader("Subject", null));
        Assert.assertEquals((Object)from, (Object)mimeMessage.getHeader("From", null));
        Assert.assertTrue((boolean)mimeMessage.getHeader("To", null).contains(recipient));
    }

    public static void assertEmailSend(WiserMessage emailMessage, boolean htmlMail, String subject, String message, String from, List<String> to, List<String> cc) throws IOException {
        try {
            MimeMessage mimeMessage = emailMessage.getMimeMessage();
            if (htmlMail) {
                Assert.assertTrue((boolean)mimeMessage.getContentType().contains("multipart/mixed"));
            } else {
                Assert.assertTrue((boolean)mimeMessage.getContentType().contains("text/plain"));
            }
            Assert.assertEquals((Object)subject, (Object)mimeMessage.getHeader("Subject", null));
            Assert.assertEquals((Object)from, (Object)mimeMessage.getHeader("From", null));
            Assert.assertTrue((boolean)EmailServiceTaskTest.getMessage(mimeMessage).contains(message));
            for (String t : to) {
                Assert.assertTrue((boolean)mimeMessage.getHeader("To", null).contains(t));
            }
            if (cc != null) {
                for (String c : cc) {
                    Assert.assertTrue((boolean)mimeMessage.getHeader("Cc", null).contains(c));
                }
            }
        }
        catch (MessagingException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static String getMessage(MimeMessage mimeMessage) throws MessagingException, IOException {
        DataHandler dataHandler = mimeMessage.getDataHandler();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dataHandler.writeTo((OutputStream)baos);
        baos.flush();
        return baos.toString();
    }
}

