/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.multiinstance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.eximeebpms.bpm.engine.test.bpmn.multiinstance.DelegateBean;
import org.eximeebpms.bpm.engine.test.bpmn.multiinstance.DelegateEvent;
import org.eximeebpms.bpm.engine.test.bpmn.multiinstance.RecordInvocationListener;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MultiInstanceTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    @Test
    public void testSequentialUserTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)3));
        String procId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstance expectedTree = ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").done();
        ActivityInstanceAssert.assertThat(tree).hasStructure(expectedTree);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        Assert.assertEquals((Object)"kermit_0", (Object)task.getAssignee());
        this.taskService.complete(task.getId());
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(expectedTree);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        Assert.assertEquals((Object)"kermit_1", (Object)task.getAssignee());
        this.taskService.complete(task.getId());
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(expectedTree);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        Assert.assertEquals((Object)"kermit_2", (Object)task.getAssignee());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    @Test
    public void testSequentialUserTasksHistory() {
        this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)4)).getId();
        for (int i = 0; i < 4; ++i) {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            Assert.assertEquals((long)4L, (long)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                Assert.assertNotNull((Object)hai.getActivityId());
                Assert.assertNotNull((Object)hai.getActivityName());
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
                Assert.assertNotNull((Object)hai.getAssignee());
            }
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
            Assert.assertEquals((long)4L, (long)historicTaskInstances.size());
            for (HistoricTaskInstance ht : historicTaskInstances) {
                Assert.assertNotNull((Object)ht.getAssignee());
                Assert.assertNotNull((Object)ht.getStartTime());
                Assert.assertNotNull((Object)ht.getEndTime());
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    @Test
    public void testSequentialUserTasksWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)3)).getId();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    @Test
    public void testSequentialUserTasksCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)10)).getId();
        for (int i = 0; i < 5; ++i) {
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            this.taskService.complete(task.getId());
        }
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSequentialMITasksExecutionListener() {
        RecordInvocationListener.reset();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("nrOfLoops", 2);
        this.runtimeService.startProcessInstanceByKey("miSequentialListener", vars);
        Assert.assertEquals((long)1L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertNull((Object)RecordInvocationListener.INVOCATIONS.get("end"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertEquals((long)1L, (long)RecordInvocationListener.INVOCATIONS.get("end").intValue());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertEquals((long)2L, (long)RecordInvocationListener.INVOCATIONS.get("end").intValue());
    }

    @Deployment
    @Test
    public void testParallelMITasksExecutionListener() {
        RecordInvocationListener.reset();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("nrOfLoops", 5);
        this.runtimeService.startProcessInstanceByKey("miSequentialListener", vars);
        Assert.assertEquals((long)5L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertNull((Object)RecordInvocationListener.INVOCATIONS.get("end"));
        List tasks = this.taskService.createTaskQuery().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Assert.assertEquals((long)5L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertEquals((long)1L, (long)RecordInvocationListener.INVOCATIONS.get("end").intValue());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.taskService.complete(((Task)tasks.get(3)).getId());
        this.taskService.complete(((Task)tasks.get(4)).getId());
        Assert.assertEquals((long)5L, (long)RecordInvocationListener.INVOCATIONS.get("start").intValue());
        Assert.assertEquals((long)5L, (long)RecordInvocationListener.INVOCATIONS.get("end").intValue());
    }

    @Deployment
    @Test
    public void testNestedSequentialUserTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialUserTasks").getId();
        for (int i = 0; i < 3; ++i) {
            Task task = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
            Assert.assertEquals((Object)"My Task", (Object)task.getName());
            ActivityInstance processInstance = this.runtimeService.getActivityInstance(procId);
            List<ActivityInstance> instancesForActivitiyId = this.getInstancesForActivityId(processInstance, "miTasks");
            Assert.assertEquals((long)1L, (long)instancesForActivitiyId.size());
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelUserTasks() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        String procId = procInst.getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)"My Task 0", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"My Task 1", (Object)((Task)tasks.get(1)).getName());
        Assert.assertEquals((Object)"My Task 2", (Object)((Task)tasks.get(2)).getName());
        ActivityInstance processInstance = this.runtimeService.getActivityInstance(procId);
        Assert.assertEquals((long)3L, (long)processInstance.getActivityInstances("miTasks").length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        processInstance = this.runtimeService.getActivityInstance(procId);
        Assert.assertEquals((long)2L, (long)processInstance.getActivityInstances("miTasks").length);
        this.taskService.complete(((Task)tasks.get(1)).getId());
        processInstance = this.runtimeService.getActivityInstance(procId);
        Assert.assertEquals((long)1L, (long)processInstance.getActivityInstances("miTasks").length);
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelReceiveTasks() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("miParallelReceiveTasks");
        String procId = procInst.getId();
        Assert.assertEquals((long)3L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        List receiveTaskExecutions = this.runtimeService.createExecutionQuery().activityId("miTasks").list();
        for (Execution execution : receiveTaskExecutions) {
            this.runtimeService.messageEventReceived("message", execution.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelReceiveTasks.bpmn20.xml"})
    @Test
    public void testParallelReceiveTasksAssertEventSubscriptionRemoval() {
        this.runtimeService.startProcessInstanceByKey("miParallelReceiveTasks");
        Assert.assertEquals((long)3L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        List receiveTaskExecutions = this.runtimeService.createExecutionQuery().activityId("miTasks").list();
        this.runtimeService.messageEventReceived("message", ((Execution)receiveTaskExecutions.get(0)).getId());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasks.bpmn20.xml"})
    @Test
    public void testParallelUserTasksHistory() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).list();
            for (int i = 0; i < historicTaskInstances.size(); ++i) {
                HistoricTaskInstance hi = (HistoricTaskInstance)historicTaskInstances.get(i);
                Assert.assertNotNull((Object)hi.getStartTime());
                Assert.assertNotNull((Object)hi.getEndTime());
                Assert.assertEquals((Object)("kermit_" + i), (Object)hi.getAssignee());
            }
            HistoricActivityInstance multiInstanceBodyInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("miTasks#multiInstanceBody").singleResult();
            Assert.assertNotNull((Object)multiInstanceBodyInstance);
            Assert.assertEquals((Object)pi.getId(), (Object)multiInstanceBodyInstance.getParentActivityInstanceId());
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            Assert.assertEquals((long)3L, (long)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
                Assert.assertNotNull((Object)hai.getAssignee());
                Assert.assertEquals((Object)"userTask", (Object)hai.getActivityType());
                Assert.assertEquals((Object)multiInstanceBodyInstance.getId(), (Object)hai.getParentActivityInstanceId());
                Assert.assertNotNull((Object)hai.getTaskId());
            }
        }
    }

    @Deployment
    @Test
    public void testParallelUserTasksWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelUserTasksCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksCompletionCondition").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)(5 - i), (long)this.taskService.createTaskQuery().count());
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelUserTasksBasedOnCollection() {
        List<String> assigneeList = Arrays.asList("kermit", "gonzo", "mispiggy", "fozzie", "bubba");
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksBasedOnCollection", CollectionUtil.singletonMap((String)"assigneeList", assigneeList)).getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().asc()).list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        Assert.assertEquals((Object)"bubba", (Object)((Task)tasks.get(0)).getAssignee());
        Assert.assertEquals((Object)"fozzie", (Object)((Task)tasks.get(1)).getAssignee());
        Assert.assertEquals((Object)"gonzo", (Object)((Task)tasks.get(2)).getAssignee());
        Assert.assertEquals((Object)"kermit", (Object)((Task)tasks.get(3)).getAssignee());
        Assert.assertEquals((Object)"mispiggy", (Object)((Task)tasks.get(4)).getAssignee());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasksBasedOnCollection.bpmn20.xml"})
    @Test
    public void testEmptyCollectionInMI() {
        ArrayList assigneeList = new ArrayList();
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksBasedOnCollection", CollectionUtil.singletonMap((String)"assigneeList", assigneeList)).getId();
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.testRule.assertProcessEnded(procId);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procId).orderByActivityId().asc()).list();
            Assert.assertEquals((long)3L, (long)activities.size());
            Assert.assertEquals((Object)"miTasks#multiInstanceBody", (Object)((HistoricActivityInstance)activities.get(0)).getActivityId());
            Assert.assertEquals((Object)"theEnd", (Object)((HistoricActivityInstance)activities.get(1)).getActivityId());
            Assert.assertEquals((Object)"theStart", (Object)((HistoricActivityInstance)activities.get(2)).getActivityId());
        }
    }

    @Deployment
    @Test
    public void testParallelUserTasksBasedOnCollectionExpression() {
        DelegateEvent.clearEvents();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("myBean", (Object)new DelegateBean()));
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"miTasks#multiInstanceBody", (Object)recordedEvents.get(0).getCurrentActivityId());
        Assert.assertEquals((Object)"miTasks#multiInstanceBody", (Object)recordedEvents.get(1).getCurrentActivityId());
        DelegateEvent.clearEvents();
    }

    @Test
    public void testSequentialUserTasksBasedOnCollectionExpression() {
        DelegateEvent.clearEvents();
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("miTasks").multiInstance().sequential()).camundaCollection("${myBean.resolveCollection(execution)}")).camundaElementVariable("elementVar")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("myBean", (Object)new DelegateBean()));
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"miTasks#multiInstanceBody", (Object)recordedEvents.get(0).getCurrentActivityId());
        Assert.assertEquals((Object)"miTasks#multiInstanceBody", (Object)recordedEvents.get(1).getCurrentActivityId());
        DelegateEvent.clearEvents();
    }

    @Deployment
    @Test
    public void testParallelUserTasksCustomExtensions() {
        HashMap<String, List<String>> vars = new HashMap<String, List<String>>();
        List<String> assigneeList = Arrays.asList("kermit", "gonzo", "fozzie");
        vars.put("assigneeList", assigneeList);
        this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", vars);
        for (String assignee : assigneeList) {
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            Assert.assertEquals((Object)assignee, (Object)task.getAssignee());
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    @Test
    public void testParallelUserTasksExecutionAndTaskListeners() {
        this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertEquals((Object)3, (Object)this.runtimeService.getVariable(waitState.getId(), "taskListenerCounter"));
        Assert.assertEquals((Object)3, (Object)this.runtimeService.getVariable(waitState.getId(), "executionListenerCounter"));
    }

    @Deployment
    @Test
    public void testNestedParallelUserTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelUserTasks").getId();
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        for (Task task : tasks) {
            Assert.assertEquals((Object)"My Task", (Object)task.getName());
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSequentialScriptTasks() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 5);
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTask", vars);
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        Assert.assertEquals((long)10L, (long)sum);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialScriptTasks.bpmn20.xml"})
    @Test
    public void testSequentialScriptTasksNoStackOverflow() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 200);
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTask", vars);
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        Assert.assertEquals((long)19900L, (long)sum);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialScriptTasks.bpmn20.xml"})
    @Test
    public void testSequentialScriptTasksHistory() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 7);
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTask", vars);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").orderByActivityId().asc()).list();
            Assert.assertEquals((long)7L, (long)historicInstances.size());
            for (int i = 0; i < 7; ++i) {
                HistoricActivityInstance hai = (HistoricActivityInstance)historicInstances.get(i);
                Assert.assertEquals((Object)"scriptTask", (Object)hai.getActivityType());
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    @Test
    public void testSequentialScriptTasksCompletionCondition() {
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTaskCompletionCondition").getId();
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        Assert.assertEquals((long)5L, (long)sum);
    }

    @Deployment
    @Test
    public void testParallelScriptTasks() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 10);
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTask", vars);
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        Assert.assertEquals((long)45L, (long)sum);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelScriptTasks.bpmn20.xml"})
    @Test
    public void testParallelScriptTasksHistory() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 4);
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTask", vars);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").list();
            Assert.assertEquals((long)4L, (long)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getStartTime());
            }
        }
    }

    @Deployment
    @Test
    public void testParallelScriptTasksCompletionCondition() {
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTaskCompletionCondition");
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        Assert.assertEquals((long)2L, (long)sum);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelScriptTasksCompletionCondition.bpmn20.xml"})
    @Test
    public void testParallelScriptTasksCompletionConditionHistory() {
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTaskCompletionCondition");
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").list();
            Assert.assertEquals((long)2L, (long)historicActivityInstances.size());
        }
    }

    @Deployment
    @Test
    public void testSequentialSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 4; ++i) {
            List tasks = query.list();
            Assert.assertEquals((long)2L, (long)tasks.size());
            Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
            Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
            if (i == 3) continue;
            List activities = this.runtimeService.getActiveActivityIds(procId);
            Assert.assertNotNull((Object)activities);
            Assert.assertEquals((long)2L, (long)activities.size());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSequentialSubProcessEndEvent() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 4; ++i) {
            List tasks = query.list();
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            if (i == 3) continue;
            List activities = this.runtimeService.getActiveActivityIds(procId);
            Assert.assertNotNull((Object)activities);
            Assert.assertEquals((long)1L, (long)activities.size());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialSubProcess.bpmn20.xml"})
    @Test
    public void testSequentialSubProcessHistory() {
        this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        for (int i = 0; i < 4; ++i) {
            List tasks = this.taskService.createTaskQuery().list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List onlySubProcessInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("subProcess").list();
            Assert.assertEquals((long)4L, (long)onlySubProcessInstances.size());
            List historicInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("subProcess").list();
            Assert.assertEquals((long)4L, (long)historicInstances.size());
            for (HistoricActivityInstance hai : historicInstances) {
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
            }
            historicInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            Assert.assertEquals((long)8L, (long)historicInstances.size());
            for (HistoricActivityInstance hai : historicInstances) {
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    @Test
    public void testSequentialSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocessWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSequentialSubProcessCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocessCompletionCondition").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 3; ++i) {
            List tasks = query.list();
            Assert.assertEquals((long)2L, (long)tasks.size());
            Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
            Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testNestedSequentialSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialSubProcess").getId();
        for (int i = 0; i < 3; ++i) {
            List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testNestedSequentialSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialSubProcessWithTimer").getId();
        for (int i = 0; i < 2; ++i) {
            List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)4L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelSubProcess.bpmn20.xml"})
    @Test
    public void testParallelSubProcessHistory() {
        HistoricActivityInstance hai;
        Iterator iterator;
        Object historicActivityInstances;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("miSubProcess").list();
            Assert.assertEquals((long)2L, (long)historicActivityInstances.size());
            iterator = historicActivityInstances.iterator();
            while (iterator.hasNext()) {
                hai = (HistoricActivityInstance)iterator.next();
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNull((Object)hai.getEndTime());
                Assert.assertNotNull((String)pi.getId(), (Object)hai.getParentActivityInstanceId());
            }
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("miSubProcess").list();
            Assert.assertEquals((long)2L, (long)historicActivityInstances.size());
            iterator = historicActivityInstances.iterator();
            while (iterator.hasNext()) {
                hai = (HistoricActivityInstance)iterator.next();
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
                Assert.assertNotNull((String)pi.getId(), (Object)hai.getParentActivityInstanceId());
            }
        }
    }

    @Deployment
    @Test
    public void testParallelSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelSubProcessCompletionCondition() {
        ActivityInstance[] taskActivities;
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessCompletionCondition").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)4L, (long)tasks.size());
        for (ActivityInstance taskActivity : taskActivities = this.runtimeService.getActivityInstance(procId).getActivityInstances("miSubProcess")[0].getChildActivityInstances()) {
            Task task = (Task)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{taskActivity.getId()}).singleResult();
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testParallelSubProcessAllAutomatic() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessAllAutomatics", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)5)).getId();
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertEquals((Object)10, (Object)this.runtimeService.getVariable(waitState.getId(), "sum"));
        this.runtimeService.signal(waitState.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelSubProcessAllAutomatic.bpmn20.xml"})
    @Test
    public void testParallelSubProcessAllAutomaticCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessAllAutomatics", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)10)).getId();
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertEquals((Object)12, (Object)this.runtimeService.getVariable(waitState.getId(), "sum"));
        this.runtimeService.signal(waitState.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testNestedParallelSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelSubProcess").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)8L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testNestedParallelSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelSubProcess").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)12L, (long)tasks.size());
        for (int i = 0; i < 3; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testSequentialCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialCallActivity").getId();
        for (int i = 0; i < 3; ++i) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
            Assert.assertEquals((long)2L, (long)tasks.size());
            Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
            Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivityWithList.bpmn20.xml"})
    @Test
    public void testSequentialCallActivityWithList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        HashMap<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();
        variables.put("list", list);
        String procId = this.runtimeService.startProcessInstanceByKey("parentProcess", variables).getId();
        Task task1 = (Task)this.taskService.createTaskQuery().processVariableValueEquals("element", (Object)"one").singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processVariableValueEquals("element", (Object)"two").singleResult();
        Assert.assertNotNull((Object)task1);
        Assert.assertNotNull((Object)task2);
        HashMap<String, String> subVariables = new HashMap<String, String>();
        subVariables.put("x", "y");
        this.taskService.complete(task1.getId(), subVariables);
        this.taskService.complete(task2.getId(), subVariables);
        Task task3 = (Task)this.taskService.createTaskQuery().processDefinitionKey("midProcess").singleResult();
        Assert.assertNotNull((Object)task3);
        this.taskService.complete(task3.getId());
        Task task4 = (Task)this.taskService.createTaskQuery().processDefinitionKey("parentProcess").singleResult();
        Assert.assertNotNull((Object)task4);
        this.taskService.complete(task4.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivityWithTimer.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testSequentialCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialCallActivityWithTimer").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testParallelCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)12L, (long)tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testParallelCallActivityHistory() {
        this.runtimeService.startProcessInstanceByKey("miParallelCallActivity");
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)12L, (long)tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
            Assert.assertEquals((long)7L, (long)historicProcessInstances.size());
            for (Object hpi : historicProcessInstances) {
                Assert.assertNotNull((Object)hpi.getStartTime());
                Assert.assertNotNull((Object)hpi.getEndTime());
            }
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("callActivity").list();
            Assert.assertEquals((long)6L, (long)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                Assert.assertNotNull((Object)hai.getStartTime());
                Assert.assertNotNull((Object)hai.getEndTime());
            }
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
            Assert.assertEquals((long)12L, (long)historicTaskInstances.size());
            for (HistoricTaskInstance hti : historicTaskInstances) {
                Assert.assertNotNull((Object)hti.getStartTime());
                Assert.assertNotNull((Object)hti.getEndTime());
                Assert.assertNotNull((Object)hti.getAssignee());
                Assert.assertEquals((Object)"completed", (Object)hti.getDeleteReason());
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivityWithTimer.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testParallelCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedSequentialCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testNestedSequentialCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialCallActivity").getId();
        for (int i = 0; i < 4; ++i) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
            Assert.assertEquals((long)2L, (long)tasks.size());
            Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
            Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedSequentialCallActivityWithTimer.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testNestedSequentialCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialCallActivityWithTimer").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"task one", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"task two", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testNestedParallelCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)14L, (long)tasks.size());
        for (int i = 0; i < 14; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivityWithTimer.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testNestedParallelCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivityWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)4L, (long)tasks.size());
        for (int i = 0; i < 3; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterTimer", (Object)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivityCompletionCondition.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    @Test
    public void testNestedParallelCallActivityCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivityCompletionCondition").getId();
        Assert.assertEquals((long)8L, (long)this.taskService.createTaskQuery().count());
        for (int i = 0; i < 2; ++i) {
            ProcessInstance nextSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("externalSubProcess").listPage(0, 1).get(0);
            List tasks = this.taskService.createTaskQuery().processInstanceId(nextSubProcessInstance.getId()).list();
            Assert.assertEquals((long)2L, (long)tasks.size());
            for (Task task : tasks) {
                this.taskService.complete(task.getId());
            }
        }
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testSequentialServiceTaskWithClass() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("multiInstanceServiceTask", CollectionUtil.singletonMap((String)"result", (Object)5));
        Integer result = (Integer)this.runtimeService.getVariable(procInst.getId(), "result");
        Assert.assertEquals((long)160L, (long)result.intValue());
        this.runtimeService.signal(procInst.getId());
        this.testRule.assertProcessEnded(procInst.getId());
    }

    @Deployment
    @Test
    public void testSequentialServiceTaskWithClassAndCollection() {
        List<Integer> items = Arrays.asList(1, 2, 3, 4, 5, 6);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("result", 1);
        vars.put("items", items);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("multiInstanceServiceTask", vars);
        Integer result = (Integer)this.runtimeService.getVariable(procInst.getId(), "result");
        Assert.assertEquals((long)720L, (long)result.intValue());
        this.runtimeService.signal(procInst.getId());
        this.testRule.assertProcessEnded(procInst.getId());
    }

    @Deployment
    @Test
    public void testAct901() {
        Date startTime = ClockUtil.getCurrentTime();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multiInstanceSubProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 61000L));
        List timers = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)5L, (long)timers.size());
        for (Job timer : timers) {
            this.managementService.executeJob(timer.getId());
        }
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.callActivityWithBoundaryErrorEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.throwingErrorEventSubProcess.bpmn20.xml"})
    @Test
    public void testMultiInstanceCallActivityWithErrorBoundaryEvent() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("assignees", Arrays.asList("kermit", "gonzo"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        variableMap = new HashMap();
        variableMap.put("done", false);
        this.taskService.complete(((Task)tasks.get(0)).getId(), variableMap);
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").list();
        Assert.assertEquals((long)0L, (long)processInstances.size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.callActivityWithBoundaryErrorEventSequential.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.throwingErrorEventSubProcess.bpmn20.xml"})
    @Test
    public void testSequentialMultiInstanceCallActivityWithErrorBoundaryEvent() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("assignees", Arrays.asList("kermit", "gonzo"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        variableMap = new HashMap();
        variableMap.put("done", false);
        this.taskService.complete(((Task)tasks.get(0)).getId(), variableMap);
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedMultiInstanceTasks.bpmn20.xml"})
    @Test
    public void testNestedMultiInstanceTasks() {
        List<String> processes = Arrays.asList("process A", "process B");
        List<String> assignees = Arrays.asList("kermit", "gonzo");
        HashMap<String, List<String>> variableMap = new HashMap<String, List<String>>();
        variableMap.put("subProcesses", processes);
        variableMap.put("assignees", assignees);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miNestedMultiInstanceTasks", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)(processes.size() * assignees.size()), (long)tasks.size());
        for (Task t : tasks) {
            this.taskService.complete(t.getId());
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("miNestedMultiInstanceTasks").list();
        Assert.assertEquals((long)0L, (long)processInstances.size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedMultiInstanceTasks.bpmn20.xml"})
    @Test
    public void testNestedMultiInstanceTasksActivityInstance() {
        List<String> processes = Arrays.asList("process A", "process B");
        List<String> assignees = Arrays.asList("kermit", "gonzo");
        HashMap<String, List<String>> variableMap = new HashMap<String, List<String>>();
        variableMap.put("subProcesses", processes);
        variableMap.put("assignees", assignees);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miNestedMultiInstanceTasks", variableMap);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("subprocess1").beginScope("subprocess1").beginMiBody("miTasks").activity("miTasks").activity("miTasks").endScope().endScope().beginScope("subprocess1").beginMiBody("miTasks").activity("miTasks").activity("miTasks").endScope().endScope().done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasks.bpmn20.xml"})
    @Test
    public void testActiveExecutionsInParallelTasks() {
        this.runtimeService.startProcessInstanceByKey("miParallelUserTasks").getId();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        List executions = this.runtimeService.createExecutionQuery().list();
        Assert.assertEquals((long)5L, (long)executions.size());
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)execution;
            if (!entity.getId().equals(instance.getId()) && !entity.getParentId().equals(instance.getId())) {
                Assert.assertTrue((boolean)entity.isActive());
                continue;
            }
            Assert.assertFalse((boolean)entity.isActive());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }
}

