/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.parse;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class GlobalRetryConfigurationTest {
    private static final String PROCESS_ID = "process";
    private static final String FAILING_CLASS = "this.class.does.not.Exist";
    private static final String FAILING_EVENT = "failingEvent";
    private static final String SCHEDULE = "R5/PT5M";
    private static final int JOB_RETRIES = 4;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setFailedJobRetryTimeCycle(SCHEDULE));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Test
    public void testFailedServiceTaskStandardStrategy() {
        this.engineRule.getProcessEngineConfiguration().setFailedJobRetryTimeCycle(null);
        BpmnModelInstance bpmnModelInstance = this.prepareFailingServiceTask();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 2);
    }

    @Test
    public void testFailedIntermediateThrowingSignalEventAsync() {
        BpmnModelInstance bpmnModelInstance = this.prepareSignalEventProcessWithoutRetry();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testFailedServiceTask() {
        BpmnModelInstance bpmnModelInstance = this.prepareFailingServiceTask();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testFailedServiceTaskMixConfiguration() {
        BpmnModelInstance bpmnModelInstance = this.prepareFailingServiceTaskWithRetryCycle();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 9);
    }

    @Test
    public void testFailedBusinessRuleTask() {
        BpmnModelInstance bpmnModelInstance = this.prepareFailingBusinessRuleTask();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testFailedCallActivity() {
        this.testRule.deploy(((CallActivityBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity().calledElement("testProcess2")).endEvent().done(), ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess2").startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).endEvent().done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess2");
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testFailingScriptTask() {
        BpmnModelInstance bpmnModelInstance = this.prepareFailingScriptTask();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testFailingSubProcess() {
        BpmnModelInstance bpmnModelInstance = this.prepareFailingSubProcess();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(pi, 4);
    }

    @Test
    public void testRetryOnAsyncStartEvent() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle(SCHEDULE)).serviceTask().camundaClass("bar")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertJobRetries(processInstance, 4);
    }

    private void assertJobRetries(ProcessInstance pi, int expectedJobRetries) {
        Assertions.assertThat((Object)pi).isNotNull();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = this.fetchJob(pi.getProcessInstanceId());
        Assert.assertEquals((long)expectedJobRetries, (long)job.getRetries());
    }

    private Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    private BpmnModelInstance prepareSignalEventProcessWithoutRetry() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(FAILING_EVENT).camundaAsyncBefore(true)).signal("start")).serviceTask().camundaClass(FAILING_CLASS)).endEvent().done();
        return modelInstance;
    }

    private BpmnModelInstance prepareFailingServiceTask() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).endEvent().done();
        return modelInstance;
    }

    private BpmnModelInstance prepareFailingServiceTaskWithRetryCycle() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R10/PT5M")).endEvent().done();
        return modelInstance;
    }

    private BpmnModelInstance prepareFailingBusinessRuleTask() {
        BpmnModelInstance modelInstance = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).endEvent().done();
        return modelInstance;
    }

    private BpmnModelInstance prepareFailingScriptTask() {
        BpmnModelInstance bpmnModelInstance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().scriptTask().scriptFormat("groovy")).scriptText("x = 5 / 0")).camundaAsyncBefore()).userTask().endEvent().done();
        return bpmnModelInstance;
    }

    private BpmnModelInstance prepareFailingSubProcess() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().camundaClass(FAILING_CLASS)).camundaAsyncBefore()).endEvent().subProcessDone().endEvent().done();
        return bpmnModelInstance;
    }
}

