/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.scripttask;

import java.util.HashMap;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.ScriptCompilationException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.scripttask.ScriptResourceBean;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ExternalScriptTaskTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testDefaultExternalScript() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testDefaultExternalScriptAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/scripttask/ExternalScriptTaskTest.testDefaultExternalScriptAsVariable.bpmn20.xml"})
    @Test
    public void testDefaultExternalScriptAsNonExistingVariable() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            Assert.fail((String)"Process variable 'scriptPath' not defined");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("Cannot resolve identifier 'scriptPath'", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testDefaultExternalScriptAsBean() {
        HashMap<String, ScriptResourceBean> variables = new HashMap<String, ScriptResourceBean>();
        variables.put("scriptResourceBean", new ScriptResourceBean());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testScriptInClasspath() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testScriptInClasspathAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "classpath://org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testScriptInClasspathAsBean() {
        HashMap<String, ScriptResourceBean> variables = new HashMap<String, ScriptResourceBean>();
        variables.put("scriptResourceBean", new ScriptResourceBean());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testScriptNotFoundInClasspath() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            Assert.fail((String)"Resource does not exist in classpath");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("unable to find resource at path classpath://org/eximeebpms/bpm/engine/test/bpmn/scripttask/notexisting.py", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/scripttask/ExternalScriptTaskTest.testScriptInDeployment.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py"})
    @Test
    public void testScriptInDeployment() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/scripttask/ExternalScriptTaskTest.testScriptInDeployment.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py"})
    @Test
    public void testScriptInDeploymentAfterCacheWasCleaned() {
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/scripttask/ExternalScriptTaskTest.testScriptInDeploymentAsVariable.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py"})
    @Test
    public void testScriptInDeploymentAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "deployment://org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/scripttask/ExternalScriptTaskTest.testScriptInDeploymentAsBean.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/scripttask/greeting.py"})
    @Test
    public void testScriptInDeploymentAsBean() {
        HashMap<String, ScriptResourceBean> variables = new HashMap<String, ScriptResourceBean>();
        variables.put("scriptResourceBean", new ScriptResourceBean());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        String greeting = (String)this.runtimeService.getVariable(processInstance.getId(), "greeting");
        Assert.assertNotNull((Object)greeting);
        Assert.assertEquals((Object)"Greetings Camunda Platform speaking", (Object)greeting);
    }

    @Deployment
    @Test
    public void testScriptNotFoundInDeployment() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            Assert.fail((String)"Resource does not exist in classpath");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("unable to find resource at path deployment://org/eximeebpms/bpm/engine/test/bpmn/scripttask/notexisting.py", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testNotExistingImport() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            Assert.fail((String)"Should fail during script compilation");
        }
        catch (ScriptCompilationException e) {
            this.testRule.assertTextPresentIgnoreCase("import unknown", e.getMessage());
        }
    }
}

