/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.scripttask;

import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ScriptEvaluationException;
import org.eximeebpms.bpm.engine.impl.scripting.engine.DefaultScriptEngineResolver;
import org.eximeebpms.bpm.engine.impl.scripting.engine.ScriptEngineResolver;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.bpmn.scripttask.AbstractScriptTaskTest;
import org.eximeebpms.bpm.engine.test.bpmn.scripttask.MySerializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScriptTaskGraalJsTest
extends AbstractScriptTaskTest {
    private static final String GRAALJS = "graal.js";
    protected ScriptEngineResolver defaultScriptEngineResolver;
    protected boolean spinEnabled = false;
    @Parameterized.Parameter(value=0)
    public boolean configureHostAccess;
    @Parameterized.Parameter(value=1)
    public boolean enableExternalResources;
    @Parameterized.Parameter(value=2)
    public boolean enableNashornCompat;

    @Before
    public void setup() {
        this.spinEnabled = this.processEngineConfiguration.getEnvScriptResolvers().stream().anyMatch(resolver -> resolver.getClass().getSimpleName().equals("SpinScriptEnvResolver"));
        this.defaultScriptEngineResolver = this.processEngineConfiguration.getScriptEngineResolver();
        this.processEngineConfiguration.setConfigureScriptEngineHostAccess(this.configureHostAccess);
        this.processEngineConfiguration.setEnableScriptEngineLoadExternalResources(this.enableExternalResources);
        this.processEngineConfiguration.setEnableScriptEngineNashornCompatibility(this.enableNashornCompat);
        this.processEngineConfiguration.setScriptEngineResolver((ScriptEngineResolver)new TestScriptEngineResolver(this.processEngineConfiguration.getScriptEngineResolver().getScriptEngineManager()));
    }

    @After
    public void resetConfiguration() {
        this.processEngineConfiguration.setConfigureScriptEngineHostAccess(true);
        this.processEngineConfiguration.setEnableScriptEngineNashornCompatibility(false);
        this.processEngineConfiguration.setEnableScriptEngineLoadExternalResources(false);
        this.processEngineConfiguration.setScriptEngineResolver(this.defaultScriptEngineResolver);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> setups() {
        return Arrays.asList({false, false, false}, {true, false, false}, {false, true, false}, {false, false, true}, {true, true, false}, {true, false, true}, {false, true, true}, {true, true, true});
    }

    @Test
    public void testJavascriptProcessVarVisibility() {
        this.deployProcess(GRAALJS, "execution.setVariable('foo', 'a');if (typeof foo !== 'undefined') {   throw 'Variable foo should be defined as script variable.';}var foo = 'b';if(execution.getVariable('foo') != 'a') {  throw 'Execution should contain variable foo';}if(foo != 'b') {  throw 'Script variable must override the visibiltity of the execution variable.';}");
        if (this.enableNashornCompat || this.configureHostAccess) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
            Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
            Assert.assertEquals((Object)"a", (Object)variableValue);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining(this.spinEnabled ? "ReferenceError" : "TypeError");
        }
    }

    @Test
    public void testJavascriptFunctionInvocation() {
        this.deployProcess(GRAALJS, "function sum(a,b){  return a+b;};var result = sum(1,2);execution.setVariable('foo', result);");
        if (this.enableNashornCompat || this.configureHostAccess) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
            Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
            Assertions.assertThat((Object)variable).isIn(new Object[]{3, 3.0});
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining(this.spinEnabled ? "ReferenceError" : "TypeError");
        }
    }

    @Test
    public void testJsVariable() {
        String scriptText = "var foo = 1;";
        this.deployProcess(GRAALJS, scriptText);
        if (this.spinEnabled && !this.enableNashornCompat && !this.configureHostAccess) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining("ReferenceError");
        } else {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
            Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
            Assert.assertNull((Object)variableValue);
        }
    }

    @Test
    public void testJavascriptVariableSerialization() {
        this.deployProcess(GRAALJS, "execution.setVariable('date', new java.util.Date(0));execution.setVariable('myVar', new org.eximeebpms.bpm.engine.test.bpmn.scripttask.MySerializable('test'));");
        if (this.enableNashornCompat || this.configureHostAccess) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
            Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
            Assert.assertEquals((long)0L, (long)date.getTime());
            MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
            Assert.assertEquals((Object)"test", (Object)myVar.getName());
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining("ReferenceError");
        }
    }

    @Test
    public void shouldLoadExternalScript() {
        this.deployProcess(GRAALJS, "load(\"" + this.getNormalizedResourcePath("/org/eximeebpms/bpm/engine/test/bpmn/scripttask/sum.js") + "\");execution.setVariable('foo', sum(3, 4));");
        if (this.enableNashornCompat || this.enableExternalResources && this.configureHostAccess) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
            Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
            Assert.assertEquals((Object)7, (Object)variableValue);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining(this.spinEnabled && !this.configureHostAccess ? "ReferenceError" : (this.enableExternalResources && !this.configureHostAccess ? "TypeError" : "Operation is not allowed"));
        }
    }

    protected static class TestScriptEngineResolver
    extends DefaultScriptEngineResolver {
        public TestScriptEngineResolver(ScriptEngineManager scriptEngineManager) {
            super(scriptEngineManager);
        }

        protected ScriptEngine getScriptEngine(String language) {
            if (ScriptTaskGraalJsTest.GRAALJS.equalsIgnoreCase(language)) {
                GraalJSScriptEngine scriptEngine = new GraalJSEngineFactory().getScriptEngine();
                this.configureScriptEngines(language, (ScriptEngine)scriptEngine);
                return scriptEngine;
            }
            return super.getScriptEngine(language);
        }
    }
}

