/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.sequenceflow;

import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.sequenceflow.ConditionalSequenceFlowTestOrder;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ConditionalSequenceFlowTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testUelExpression() {
        Map variables = CollectionUtil.singletonMap((String)"input", (Object)"right");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("condSeqFlowUelExpr", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"task right", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testValueAndMethodExpression() {
        ConditionalSequenceFlowTestOrder order = new ConditionalSequenceFlowTestOrder(150);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("uelExpressions", CollectionUtil.singletonMap((String)"order", (Object)order));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)"Standard service", (Object)task.getName());
        order = new ConditionalSequenceFlowTestOrder(300);
        processInstance = this.runtimeService.startProcessInstanceByKey("uelExpressions", CollectionUtil.singletonMap((String)"order", (Object)order));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)"Premium service", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testNoExpressionTrueThrowsException() {
        Map variables = CollectionUtil.singletonMap((String)"input", (Object)"non-existing-value");
        try {
            this.runtimeService.startProcessInstanceByKey("condSeqFlowUelExpr", variables);
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("No conditional sequence flow leaving the Flow Node 'theStart' could be selected for continuing the process", e.getMessage());
        }
    }
}

