/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.sequenceflow;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class UncontrolledFlowTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSubProcessTwoOutgoingFlowsCorrelateMessage() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerTask1").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerTask2").count());
        try {
            this.runtimeService.correlateMessage("Message1");
            Assert.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot correlate message 'Message1'", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testSubProcessTwoOutgoingFlowsEndProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }
}

