/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.servicetask;

import java.util.Collection;
import org.eximeebpms.bpm.engine.test.bpmn.servicetask.ModelExecutionContextServiceTask;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.instance.Event;
import org.eximeebpms.bpm.model.bpmn.instance.Process;
import org.eximeebpms.bpm.model.bpmn.instance.ServiceTask;
import org.eximeebpms.bpm.model.bpmn.instance.Task;
import org.eximeebpms.bpm.model.xml.Model;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ServiceTaskBpmnModelExecutionContextTest
extends PluggableProcessEngineTest {
    private static final String PROCESS_ID = "process";
    private String deploymentId;

    @Test
    public void testJavaDelegateModelExecutionContext() {
        this.deploy();
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        BpmnModelInstance modelInstance = ModelExecutionContextServiceTask.modelInstance;
        Assert.assertNotNull((Object)modelInstance);
        Model model = modelInstance.getModel();
        Collection events = modelInstance.getModelElementsByType(model.getType(Event.class));
        Assert.assertEquals((long)2L, (long)events.size());
        Collection tasks = modelInstance.getModelElementsByType(model.getType(Task.class));
        Assert.assertEquals((long)1L, (long)tasks.size());
        Process process = (Process)modelInstance.getDefinitions().getRootElements().iterator().next();
        Assert.assertEquals((Object)PROCESS_ID, (Object)process.getId());
        Assert.assertTrue((boolean)process.isExecutable());
        ServiceTask serviceTask = ModelExecutionContextServiceTask.serviceTask;
        Assert.assertNotNull((Object)serviceTask);
        Assert.assertEquals((Object)ModelExecutionContextServiceTask.class.getName(), (Object)serviceTask.getCamundaClass());
    }

    private void deploy() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(ModelExecutionContextServiceTask.class.getName())).endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
    }

    @After
    public void tearDown() {
        ModelExecutionContextServiceTask.clear();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

