/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.tasklistener.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.DelegateTask;
import org.eximeebpms.bpm.engine.delegate.TaskListener;

public class RecorderTaskListener
implements TaskListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static List<RecordedTaskEvent> recordedEvents = new ArrayList<RecordedTaskEvent>();
    private static LinkedList<String> orderedEvents = new LinkedList();
    private static Map<String, Integer> eventCounters = new HashMap<String, Integer>();

    public void notify(DelegateTask task) {
        DelegateExecution execution = task.getExecution();
        String eventName = task.getEventName();
        recordedEvents.add(new RecordedTaskEvent(task.getId(), task.getExecutionId(), eventName, execution.getActivityInstanceId()));
        orderedEvents.addLast(eventName);
        Integer counter = eventCounters.get(eventName);
        if (counter == null) {
            eventCounters.put(eventName, 1);
        } else {
            counter = counter + 1;
            eventCounters.put(eventName, counter);
        }
    }

    public static void clear() {
        recordedEvents.clear();
        orderedEvents.clear();
        eventCounters.clear();
    }

    public static List<RecordedTaskEvent> getRecordedEvents() {
        return recordedEvents;
    }

    public static LinkedList<String> getOrderedEvents() {
        return orderedEvents;
    }

    public static Map<String, Integer> getEventCounters() {
        return eventCounters;
    }

    public static int getTotalEventCount() {
        int total = 0;
        for (Integer eventCount : eventCounters.values()) {
            total += eventCount != null ? eventCount : 0;
        }
        return total;
    }

    public static int getEventCount(String eventName) {
        Integer count = eventCounters.get(eventName);
        return count != null ? count : 0;
    }

    public static class RecordedTaskEvent {
        protected String taskId;
        protected String executionId;
        protected String event;
        protected String activityInstanceId;

        public RecordedTaskEvent(String taskId, String executionId, String event, String activityInstanceId) {
            this.executionId = executionId;
            this.taskId = taskId;
            this.event = event;
            this.activityInstanceId = activityInstanceId;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getEvent() {
            return this.event;
        }

        public String getActivityInstanceId() {
            return this.activityInstanceId;
        }
    }
}

