/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.handler.specification;

import org.eximeebpms.bpm.engine.delegate.Expression;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.eximeebpms.bpm.engine.test.cmmn.handler.specification.SpecUtil;
import org.eximeebpms.bpm.model.cmmn.CmmnModelInstance;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaCaseExecutionListener;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaExpression;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaField;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaString;
import org.junit.Assert;

public class FieldSpec {
    protected String fieldName;
    protected String expression;
    protected String childExpression;
    protected String stringValue;
    protected String childStringValue;

    public FieldSpec(String fieldName, String expression, String childExpression, String stringValue, String childStringValue) {
        this.fieldName = fieldName;
        this.expression = expression;
        this.childExpression = childExpression;
        this.stringValue = stringValue;
        this.childStringValue = childStringValue;
    }

    public void verify(FieldDeclaration field) {
        Assert.assertEquals((Object)this.fieldName, (Object)field.getName());
        Object fieldValue = field.getValue();
        Assert.assertNotNull((Object)fieldValue);
        Assert.assertTrue((boolean)(fieldValue instanceof Expression));
        Expression expressionValue = (Expression)fieldValue;
        Assert.assertEquals((Object)this.getExpectedExpression(), (Object)expressionValue.getExpressionText());
    }

    public void addFieldToListenerElement(CmmnModelInstance modelInstance, CamundaCaseExecutionListener listenerElement) {
        CamundaField field = SpecUtil.createElement(modelInstance, (CmmnModelElementInstance)listenerElement, null, CamundaField.class);
        field.setCamundaName(this.fieldName);
        if (this.expression != null) {
            field.setCamundaExpression(this.expression);
        } else if (this.childExpression != null) {
            CamundaExpression fieldExpressionChild = SpecUtil.createElement(modelInstance, (CmmnModelElementInstance)field, null, CamundaExpression.class);
            fieldExpressionChild.setTextContent(this.childExpression);
        } else if (this.stringValue != null) {
            field.setCamundaStringValue(this.stringValue);
        } else if (this.childStringValue != null) {
            CamundaString fieldExpressionChild = SpecUtil.createElement(modelInstance, (CmmnModelElementInstance)field, null, CamundaString.class);
            fieldExpressionChild.setTextContent(this.childStringValue);
        }
    }

    protected String getExpectedExpression() {
        if (this.expression != null) {
            return this.expression;
        }
        if (this.childExpression != null) {
            return this.childExpression;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        return this.childStringValue;
    }
}

