/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.delegate.CaseExecutionListener;
import org.eximeebpms.bpm.engine.delegate.DelegateCaseExecution;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.eximeebpms.bpm.engine.impl.test.TestLogger;
import org.slf4j.Logger;

public class CaseExecutionStateTransitionCollector
implements CaseExecutionListener {
    private static final Logger LOG = TestLogger.TEST_LOGGER.getLogger();
    public List<String> stateTransitions = new ArrayList<String>();

    public void notify(DelegateCaseExecution planItem) throws Exception {
        CmmnExecution execution = (CmmnExecution)planItem;
        String activityId = execution.getEventSource().getId();
        CaseExecutionState previousState = execution.getPreviousState();
        String previousStateName = "()";
        if (!previousState.equals(CaseExecutionState.NEW)) {
            previousStateName = previousState.toString();
        }
        CaseExecutionState newState = execution.getCurrentState();
        String stateTransition = previousStateName + " --" + execution.getEventName() + "(" + activityId + ")--> " + newState;
        LOG.debug("collecting state transition: " + stateTransition);
        this.stateTransitions.add(stateTransition);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (String event : this.stateTransitions) {
            text.append(event);
            text.append("\n");
        }
        return text.toString();
    }
}

