/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.sentry;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartQueryImpl;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.cmmn.CmmnTest;
import org.eximeebpms.bpm.model.cmmn.VariableTransition;
import org.junit.Assert;
import org.junit.Test;

public class SentryInitializationTest
extends CmmnTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testOnPart.cmmn"})
    @Test
    public void testOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        Assert.assertEquals((long)1L, (long)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"planItemOnPart", (Object)part.getType());
        Assert.assertEquals((Object)"PI_HumanTask_1", (Object)part.getSource());
        Assert.assertEquals((Object)"complete", (Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testVariableOnPart.cmmn"})
    @Test
    public void testVariableOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        Assert.assertEquals((long)1L, (long)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"variableOnPart", (Object)part.getType());
        Assert.assertEquals((Object)VariableTransition.create.name(), (Object)part.getVariableEvent());
        Assert.assertEquals((Object)"variable_1", (Object)part.getVariableName());
        Assert.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testIfPart.cmmn"})
    @Test
    public void testIfPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        List parts = this.createCaseSentryPartQuery().list();
        Assert.assertEquals((long)1L, (long)parts.size());
        CaseSentryPartEntity part = (CaseSentryPartEntity)parts.get(0);
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"ifPart", (Object)part.getType());
        Assert.assertNull((Object)part.getSource());
        Assert.assertNull((Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testOnPartIfPartAndVariableOnPart.cmmn"})
    @Test
    public void testOnPartIfPartAndVariableOnPart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        Assert.assertEquals((long)3L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.type("ifPart").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"ifPart", (Object)part.getType());
        Assert.assertNull((Object)part.getSource());
        Assert.assertNull((Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.type("planItemOnPart").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"planItemOnPart", (Object)part.getType());
        Assert.assertEquals((Object)"PI_HumanTask_1", (Object)part.getSource());
        Assert.assertEquals((Object)"complete", (Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.type("variableOnPart").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"variableOnPart", (Object)part.getType());
        Assert.assertEquals((Object)VariableTransition.delete.name(), (Object)part.getVariableEvent());
        Assert.assertEquals((Object)"variable_1", (Object)part.getVariableName());
        Assert.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testMultipleSentries.cmmn"})
    @Test
    public void testMultipleSentries() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.sentryId("Sentry_1").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"ifPart", (Object)part.getType());
        Assert.assertNull((Object)part.getSource());
        Assert.assertNull((Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.sentryId("Sentry_2").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)"Sentry_2", (Object)part.getSentryId());
        Assert.assertEquals((Object)"planItemOnPart", (Object)part.getType());
        Assert.assertEquals((Object)"PI_HumanTask_1", (Object)part.getSource());
        Assert.assertEquals((Object)"complete", (Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryInitializationTest.testMultipleSentriesWithinStage.cmmn"})
    @Test
    public void testMultipleSentriesWithinStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("myVar", (Object)0).create().getId();
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        String stageId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        Assert.assertEquals((long)2L, (long)query.count());
        CaseSentryPartEntity part = (CaseSentryPartEntity)query.sentryId("Sentry_1").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)stageId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)"Sentry_1", (Object)part.getSentryId());
        Assert.assertEquals((Object)"ifPart", (Object)part.getType());
        Assert.assertNull((Object)part.getSource());
        Assert.assertNull((Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
        part = (CaseSentryPartEntity)query.sentryId("Sentry_2").singleResult();
        Assert.assertEquals((Object)caseInstanceId, (Object)part.getCaseInstanceId());
        Assert.assertEquals((Object)stageId, (Object)part.getCaseExecutionId());
        Assert.assertEquals((Object)"Sentry_2", (Object)part.getSentryId());
        Assert.assertEquals((Object)"planItemOnPart", (Object)part.getType());
        Assert.assertEquals((Object)"PI_HumanTask_1", (Object)part.getSource());
        Assert.assertEquals((Object)"complete", (Object)part.getStandardEvent());
        Assert.assertFalse((boolean)part.isSatisfied());
    }
}

