/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.stage;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.cmmn.CmmnTest;
import org.junit.Assert;
import org.junit.Test;

public class AutoCompleteTest
extends CmmnTest {
    protected static final String CASE_DEFINITION_KEY = "case";

    @Deployment
    @Test
    public void testCasePlanModel() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertNull((Object)query.activityId("PI_HumanTask_1").singleResult());
        Assert.assertNull((Object)query.activityId("PI_HumanTask_2").singleResult());
    }

    @Deployment
    @Test
    public void testStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        String stageId = ((CaseExecution)query.singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(stageId);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertNotNull((Object)query.activityId("PI_HumanTask_1").singleResult());
        Assert.assertNull((Object)query.activityId("PI_Stage_1").singleResult());
        Assert.assertNull((Object)query.activityId("PI_HumanTask_2").singleResult());
        Assert.assertNull((Object)query.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    @Test
    public void testManualActivationDisabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
    }

    @Deployment
    @Test
    public void testManualActivationDisabledInsideStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String stageId = ((CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult()).getId();
        CaseExecution stage = (CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult();
        Assert.assertNotNull((Object)stage);
        Assert.assertTrue((boolean)stage.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertNotNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    @Test
    public void testNested() {
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_1").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_2").singleResult());
        Assert.assertNull((Object)executionQuery.activityId("PI_HumanTask_3").singleResult());
    }

    @Deployment
    @Test
    public void testRequiredEnabled() {
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery();
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseInstance caseInstance = (CaseInstance)instanceQuery.caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.manualStart(humanTask1Id);
        this.complete(humanTask1Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.manualStart(humanTask2Id);
        this.complete(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    @Test
    public void testRequiredEnabledInsideStage() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask3Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_3").singleResult()).getId();
        this.complete(humanTask3Id);
        CaseExecution stage = (CaseExecution)executionQuery.activityId("PI_Stage_1").singleResult();
        Assert.assertNotNull((Object)stage);
        Assert.assertTrue((boolean)stage.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        Assert.assertNull((Object)executionQuery.activityId("PI_Stage_1").singleResult());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment
    @Test
    public void testEntryCriteriaAndManualActivationDisabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.complete(humanTask1Id);
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.complete(humanTask2Id);
        caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    @Test
    public void testExitCriteriaAndRequiredEnabled() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        String humanTask1Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution humanTask2 = (CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult();
        this.manualStart(humanTask2.getId());
        this.complete(humanTask1Id);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/stage/AutoCompleteTest.testRequiredEnabled.cmmn"})
    @Test
    public void testTerminate() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_DEFINITION_KEY).getId();
        CaseExecutionQuery executionQuery = this.caseService.createCaseExecutionQuery();
        CaseInstanceQuery instanceQuery = this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId);
        String humanTask2Id = ((CaseExecution)executionQuery.activityId("PI_HumanTask_2").singleResult()).getId();
        this.manualStart(humanTask2Id);
        this.terminate(humanTask2Id);
        CaseInstance caseInstance = (CaseInstance)instanceQuery.singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/stage/AutoCompleteTest.testProcessTasksOnStage.cmmn", "org/eximeebpms/bpm/engine/test/cmmn/stage/AutoCompleteTest.testProcessTasksOnStage.bpmn"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testProcessTasksOnStage() {
        this.createCaseInstanceByKey(CASE_DEFINITION_KEY);
        List historicCaseActivityInstances = this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityType("processTask").list();
        Assertions.assertThat((List)historicCaseActivityInstances).hasSize(2);
    }
}

