/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.tasklistener;

import org.eximeebpms.bpm.engine.delegate.TaskListener;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.FieldInjectionTaskListener;
import org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.MySpecialTaskListener;
import org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.MyTaskListener;
import org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.NotTaskListener;
import org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.TaskDeleteListener;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class TaskListenerTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByClass.cmmn"})
    @Test
    public void testCreateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByExpression.cmmn"})
    @Test
    public void testCreateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByDelegateExpression.cmmn"})
    @Test
    public void testCreateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByScript.cmmn"})
    @Test
    public void testCreateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByClass.cmmn"})
    @Test
    public void testCompleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByExpression.cmmn"})
    @Test
    public void testCompleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByDelegateExpression.cmmn"})
    @Test
    public void testCompleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByScript.cmmn"})
    @Test
    public void testCompleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByClass.cmmn"})
    @Test
    public void testDeleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByExpression.cmmn"})
    @Test
    public void testDeleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByDelegateExpression.cmmn"})
    @Test
    public void testDeleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByScript.cmmn"})
    @Test
    public void testDeleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByCaseInstanceDeletion.cmmn"})
    @Test
    public void testDeleteListenerByCaseInstanceDeletion() {
        TaskDeleteListener.clear();
        final String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().deleteCaseInstance(caseInstanceId, null);
                return null;
            }
        });
        Assert.assertEquals((long)1L, (long)TaskDeleteListener.eventCounter);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByClass.cmmn"})
    @Test
    public void testAssignmentListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByExpression.cmmn"})
    @Test
    public void testAssignmentListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByDelegateExpression.cmmn"})
    @Test
    public void testAssignmentListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByScript.cmmn"})
    @Test
    public void testAssignmentListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByInitialInstantiation.cmmn"})
    @Test
    public void testAssignmentListenerByInitialInstantiation() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByClass.cmmn"})
    @Test
    public void testUpdateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByExpression.cmmn"})
    @Test
    public void testUpdateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByDelegateExpression.cmmn"})
    @Test
    public void testUpdateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByScript.cmmn"})
    @Test
    public void testUpdateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByInitialInstantiation.cmmn"})
    @Test
    public void testUpdateListenerNotInvokedByInitialInstantiation() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByClass.cmmn"})
    @Test
    public void testAllListenerByClassExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)9L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByClass.cmmn"})
    @Test
    public void testAllListenerByClassExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)9L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByExpression.cmmn"})
    @Test
    public void testAllListenerByExpressionExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByExpression.cmmn"})
    @Test
    public void testAllListenerByExpressionExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByDelegateExpression.cmmn"})
    @Test
    public void testAllListenerByDelegateExpressionExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByDelegateExpression.cmmn"})
    @Test
    public void testAllListenerByDelegateExpressionExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByScript.cmmn"})
    @Test
    public void testAllListenerByScriptExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)9L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByScript.cmmn"})
    @Test
    public void testAllListenerByScriptExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)9L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testFieldInjectionByClass.cmmn"})
    @Test
    public void testFieldInjectionByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        Assert.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        Assert.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        Assert.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testFieldInjectionByDelegateExpression.cmmn"})
    @Test
    public void testFieldInjectionByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new FieldInjectionTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        Assert.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        Assert.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        Assert.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testListenerByScriptResource.cmmn", "org/eximeebpms/bpm/engine/test/cmmn/tasklistener/taskListener.groovy"})
    @Test
    public void testListenerByScriptResource() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)7L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)3, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDoesNotImplementTaskListenerInterfaceByClass.cmmn"})
    @Test
    public void testDoesNotImplementTaskListenerInterfaceByClass() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.testRule.assertTextPresent("NotTaskListener doesn't implement " + TaskListener.class, message);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDoesNotImplementTaskListenerInterfaceByDelegateExpression.cmmn"})
    @Test
    public void testDoesNotImplementTaskListenerInterfaceByDelegateExpression() {
        try {
            this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new NotTaskListener()).create().getId();
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.testRule.assertTextPresent("Delegate expression ${myTaskListener} did not resolve to an implementation of interface " + TaskListener.class.getName(), message);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testTaskListenerDoesNotExist.cmmn"})
    @Test
    public void testTaskListenerDoesNotExist() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.testRule.assertTextPresent("Exception while instantiating class 'org.eximeebpms.bpm.engine.test.cmmn.tasklistener.util.NotExistingTaskListener'", message);
        }
    }

    protected void terminate(final String caseExecutionId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CmmnExecution caseTask = (CmmnExecution)TaskListenerTest.this.caseService.createCaseExecutionQuery().caseExecutionId(caseExecutionId).singleResult();
                caseTask.terminate();
                return null;
            }
        });
    }
}

