/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ControllableThread;
import org.eximeebpms.bpm.engine.test.concurrency.ControlledCommand;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

@Ignore
public class CompetingForkTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;
    static String jobId;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Deployment
    @Ignore
    @Test
    public void testCompetingFork() throws Exception {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        String task1 = ((Task)query.taskDefinitionKey("task1").singleResult()).getId();
        String task2 = ((Task)query.taskDefinitionKey("task2").singleResult()).getId();
        String task3 = ((Task)query.taskDefinitionKey("task3").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        CompleteTaskThread threadOne = new CompleteTaskThread(task1);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread thread two");
        CompleteTaskThread threadTwo = new CompleteTaskThread(task2);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread three");
        CompleteTaskThread threadThree = new CompleteTaskThread(task3);
        threadThree.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
        LOG.debug("test thread notifies thread 3");
        threadThree.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadThree.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadThree.exception.getMessage());
    }

    public class CompleteTaskThread
    extends ControllableThread {
        String taskId;
        OptimisticLockingException exception;

        public CompleteTaskThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingForkTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.taskId, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

