/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.impl.cmd.SetLicenseKeyCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompetingLicenseKeyAccessTest
extends ConcurrencyTestCase {
    private ConcurrencyTestHelper.ThreadControl asyncThread;

    @Before
    public void setUp() throws Exception {
        this.managementService.setLicenseKey("testLicenseKey");
    }

    @After
    public void tearDown() throws Exception {
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void testConcurrentlyDeleteAndSetLicense() {
        this.managementService.setLicenseKey("testLicenseKey");
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateLicenseCmd());
        this.asyncThread.waitForSync();
        this.managementService.deleteLicenseKey();
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        Assertions.assertThat((Throwable)exception).isNotNull();
        Assertions.assertThat((boolean)(exception instanceof OptimisticLockingException)).isTrue();
    }

    @Test
    public void testConcurrentlyAlterLicense() {
        this.managementService.setLicenseKey("testLicenseKey");
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateLicenseCmd());
        this.asyncThread.waitForSync();
        this.managementService.setLicenseKey("updatedTestLicenseKey");
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        Assertions.assertThat((Throwable)exception).isNotNull();
        Assertions.assertThat((boolean)(exception instanceof OptimisticLockingException)).isTrue();
    }

    private static class FetchAndUpdateLicenseCmd
    extends ConcurrencyTestHelper.ControllableCommand<Long> {
        private FetchAndUpdateLicenseCmd() {
        }

        public Long execute(CommandContext commandContext) {
            ResourceEntity licenseKey = commandContext.getResourceManager().findLicenseKeyResource();
            Assert.assertNotNull((String)"license key is expected to be not null", (Object)licenseKey);
            this.monitor.sync();
            licenseKey.setBytes("updatedTestLicenseKeyBySecondThread".getBytes());
            new SetLicenseKeyCmd(new String(licenseKey.getBytes())).execute(commandContext);
            return null;
        }
    }
}

