/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.CompleteCaseExecutionCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.DisableCaseExecutionCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.StateTransitionCaseExecutionCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ControllableThread;
import org.eximeebpms.bpm.engine.test.concurrency.ControlledCommand;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class CompetingParentCompletionTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected CaseService caseService;
    protected static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.caseService = this.engineRule.getCaseService();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingParentCompletionTest.testComplete.cmmn"})
    @Test
    public void testComplete() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        CompletionSingleThread threadOne = new CompletionSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingParentCompletionTest.testDisable.cmmn"})
    @Test
    public void testDisable() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        DisableSingleThread threadOne = new DisableSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        DisableSingleThread threadTwo = new DisableSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingParentCompletionTest.testTerminate.cmmn"})
    @Test
    public void testTerminate() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        TerminateSingleThread threadOne = new TerminateSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        TerminateSingleThread threadTwo = new TerminateSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public class CompletionSingleThread
    extends SingleThread {
        public CompletionSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new CompleteCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public abstract class SingleThread
    extends ControllableThread {
        String caseExecutionId;
        OptimisticLockingException exception;
        protected StateTransitionCaseExecutionCmd cmd;

        public SingleThread(String caseExecutionId, StateTransitionCaseExecutionCmd cmd) {
            this.caseExecutionId = caseExecutionId;
            this.cmd = cmd;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingParentCompletionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, this.cmd));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }

    public class DisableSingleThread
    extends SingleThread {
        public DisableSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new DisableCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public class TerminateSingleThread
    extends SingleThread {
        public TerminateSingleThread(String caseExecutionId) {
            super(caseExecutionId, new StateTransitionCaseExecutionCmd(caseExecutionId, null, null, null, null){
                private static final long serialVersionUID = 1L;

                protected void performStateTransition(CommandContext commandContext, CaseExecutionEntity caseExecution) {
                    caseExecution.terminate();
                }
            });
        }
    }
}

