/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.cmd.HistoryCleanupCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.util.DatabaseHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ConcurrentHistoryCleanupTest
extends ConcurrencyTestCase {
    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            List jobs = this.processEngine.getManagementService().createJobQuery().list();
            if (jobs.size() > 0) {
                String jobId = ((Job)jobs.get(0)).getId();
                commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
            }
            return null;
        });
    }

    @Test
    @RequiredDatabase(excludes={"h2"})
    public void testRunTwoHistoryCleanups() throws InterruptedException {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        Assume.assumeTrue((transactionIsolationLevel != null && !transactionIsolationLevel.equals(2) ? 1 : 0) != 0);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableHistoryCleanupCommand());
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableHistoryCleanupCommand());
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        List historyCleanupJobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
    }

    protected static class ControllableHistoryCleanupCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableHistoryCleanupCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new HistoryCleanupCmd(true).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

