/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.Collections;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.SetTaskVariablesCmd;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ControllableThread;
import org.eximeebpms.bpm.engine.test.concurrency.ControlledCommand;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class ConcurrentVariableUpdateTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    @Test
    @RequiredDatabase(excludes={"db2"})
    public void testConcurrentVariableCreate() {
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("varName1", "someValue"));
        String variableName = "varName";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        Assert.assertNull((Object)thread1.exception);
        Assert.assertNull((Object)((Object)thread1.optimisticLockingException));
        thread2.proceedAndWaitTillDone();
        Assert.assertNull((Object)thread2.exception);
        Assert.assertNotNull((Object)((Object)thread2.optimisticLockingException));
        this.taskService.complete(taskId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    @Test
    public void testConcurrentVariableUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "varName";
        this.taskService.setVariable(taskId, variableName, (Object)"someValue");
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someOtherString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        thread2.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)thread1.optimisticLockingException));
        Assert.assertNotNull((Object)((Object)thread2.optimisticLockingException));
        this.taskService.complete(taskId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    @Test
    public void testConcurrentVariableUpdateTypeChange() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "varName";
        this.taskService.setVariable(taskId, variableName, (Object)"someValue");
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, (Object)100L);
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someOtherString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        thread2.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)thread1.optimisticLockingException));
        Assert.assertNotNull((Object)((Object)thread2.optimisticLockingException));
        this.taskService.complete(taskId);
    }

    class SetTaskVariablesThread
    extends ControllableThread {
        OptimisticLockingException optimisticLockingException;
        Exception exception;
        protected Object variableValue;
        protected String taskId;
        protected String variableName;

        public SetTaskVariablesThread(String taskId, String variableName, Object variableValue) {
            this.taskId = taskId;
            this.variableName = variableName;
            this.variableValue = variableValue;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                ConcurrentVariableUpdateTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SetTaskVariablesCmd(this.taskId, Collections.singletonMap(this.variableName, this.variableValue), false)));
            }
            catch (OptimisticLockingException e) {
                this.optimisticLockingException = e;
            }
            catch (Exception e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

