/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JdbcStatementTimeoutTest
extends ConcurrencyTestHelper {
    private static final int STATEMENT_TIMEOUT_IN_SECONDS = 1;
    private static final int TEST_TIMEOUT_IN_MILLIS = 10000;
    private static final String JOB_ENTITY_ID = "42";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJdbcStatementTimeout(Integer.valueOf(1)));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private ConcurrencyTestHelper.ThreadControl thread1;
    private ConcurrencyTestHelper.ThreadControl thread2;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        if (this.thread1 != null) {
            this.thread1.waitUntilDone();
            this.deleteJobEntities();
        }
        for (ConcurrencyTestHelper.ControllableCommand controllableCommand : this.controllableCommands) {
            ConcurrencyTestHelper.ThreadControl threadControl = controllableCommand.monitor;
            threadControl.executingThread.interrupt();
            threadControl.executingThread.join();
        }
        Thread.interrupted();
    }

    @Test
    @RequiredDatabase(excludes={"db2", "h2"})
    public void testTimeoutOnUpdate() {
        this.createJobEntity();
        this.thread1 = this.executeControllableCommand(new UpdateJobCommand("p1"));
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new UpdateJobCommand("p2"));
        this.thread2.waitForSync();
        this.thread1.makeContinue();
        this.thread1.waitForSync();
        this.thread2.reportInterrupts();
        this.thread2.makeContinue();
        this.thread2.waitForSync(10000L);
        Assert.assertNotNull((String)"expected timeout exception", (Object)this.thread2.getException());
    }

    private void createJobEntity() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<JobEntity>(){

            public JobEntity execute(CommandContext commandContext) {
                MessageEntity jobEntity = new MessageEntity();
                jobEntity.setId(JdbcStatementTimeoutTest.JOB_ENTITY_ID);
                jobEntity.insert();
                return jobEntity;
            }
        });
    }

    private void deleteJobEntities() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = commandContext.getDbEntityManager().createJobQuery().list();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job, false);
                }
                for (HistoricJobLog jobLog : commandContext.getDbEntityManager().createHistoricJobLogQuery().list()) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(jobLog.getId());
                }
                return null;
            }
        });
    }

    static class UpdateJobCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String lockOwner;

        public UpdateJobCommand(String lockOwner) {
            this.lockOwner = lockOwner;
        }

        public Void execute(CommandContext commandContext) {
            DbEntityManagerFactory dbEntityManagerFactory = new DbEntityManagerFactory(Context.getProcessEngineConfiguration().getIdGenerator());
            DbEntityManager entityManager = dbEntityManagerFactory.openSession();
            JobEntity job = (JobEntity)entityManager.selectById(JobEntity.class, JdbcStatementTimeoutTest.JOB_ENTITY_ID);
            job.setLockOwner(this.lockOwner);
            entityManager.forceUpdate((DbEntity)job);
            this.monitor.sync();
            entityManager.flush();
            this.monitor.sync();
            commandContext.getTransactionContext().commit();
            return null;
        }
    }
}

