/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListSet;
import org.junit.Assert;
import org.junit.Test;

public class UuidGeneratorTest {
    private static final int THREAD_COUNT = 10;
    private static final int LOOP_COUNT = 10000;

    @Test
    public void testMultithreaded() throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final TimeBasedGenerator timeBasedGenerator = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
        final ConcurrentSkipListSet generatedIds = new ConcurrentSkipListSet();
        final ConcurrentSkipListSet duplicatedIds = new ConcurrentSkipListSet();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 10000; ++j) {
                        String id = timeBasedGenerator.generate().toString();
                        boolean wasAdded = generatedIds.add(id);
                        if (wasAdded) continue;
                        duplicatedIds.add(id);
                    }
                }
            });
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((long)100000L, (long)generatedIds.size());
        Assert.assertTrue((boolean)duplicatedIds.isEmpty());
    }
}

