/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.dmn.businessruletask;

import java.util.Collections;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionResult;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionResultEntries;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.dmn.businessruletask.DecisionResultTestListener;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DmnDecisionResultListenerTest
extends PluggableProcessEngineTest {
    protected static final String TEST_PROCESS = "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml";
    protected static final String TEST_DECISION = "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_SUM = "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_COUNT = "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml";
    protected DmnDecisionResult results;

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testNoOutput() {
        this.startTestProcess("no output");
        Assert.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testEmptyOutput() {
        this.startTestProcess("empty output");
        Assert.assertFalse((String)"The decision result 'ruleResult' should not be empty", (boolean)this.results.isEmpty());
        DmnDecisionResultEntries decisionOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertNull((Object)decisionOutput.getFirstEntry());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testEmptyMap() {
        this.startTestProcess("empty map");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertTrue((String)"The decision output should be empty", (boolean)output.isEmpty());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testSingleEntry() {
        this.startTestProcess("single entry");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((Object)"foo", (Object)firstOutput.getFirstEntry());
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testMultipleEntries() {
        this.startTestProcess("multiple entries");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((Object)"foo", (Object)firstOutput.get((Object)"result1"));
        Assert.assertEquals((Object)"bar", (Object)firstOutput.get((Object)"result2"));
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getEntryTyped("result1"));
        Assert.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)firstOutput.getEntryTyped("result2"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testSingleEntryList() {
        this.startTestProcess("single entry list");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertEquals((Object)"foo", (Object)output.getFirstEntry());
            Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getFirstEntryTyped());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testMultipleEntriesList() {
        this.startTestProcess("multiple entries list");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertEquals((long)2L, (long)output.size());
            Assert.assertEquals((Object)"foo", (Object)output.get((Object)"result1"));
            Assert.assertEquals((Object)"bar", (Object)output.get((Object)"result2"));
            Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getEntryTyped("result1"));
            Assert.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)output.getEntryTyped("result2"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectCountHitPolicyNoOutput() {
        this.startTestProcess("no output");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)0L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)0), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicyNoOutput() {
        this.startTestProcess("no output");
        Assert.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicySingleEntry() {
        this.startTestProcess("single entry");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)12L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)12), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/eximeebpms/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicySingleEntryList() {
        this.startTestProcess("single entry list");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)33L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)33), (Object)firstOutput.getFirstEntryTyped());
    }

    protected ProcessInstance startTestProcess(String input) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("input", input));
        this.results = DecisionResultTestListener.getDecisionResult();
        Assert.assertNotNull((Object)this.results);
        return processInstance;
    }

    @After
    public void tearDown() throws Exception {
        DecisionResultTestListener.reset();
    }
}

