/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.dmn.deployment;

import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentQuery;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.dmn.Dmn;
import org.eximeebpms.bpm.model.dmn.DmnModelInstance;
import org.eximeebpms.bpm.model.dmn.HitPolicy;
import org.eximeebpms.bpm.model.dmn.instance.Decision;
import org.eximeebpms.bpm.model.dmn.instance.DecisionTable;
import org.eximeebpms.bpm.model.dmn.instance.Definitions;
import org.eximeebpms.bpm.model.dmn.instance.Input;
import org.eximeebpms.bpm.model.dmn.instance.InputExpression;
import org.eximeebpms.bpm.model.dmn.instance.Output;
import org.eximeebpms.bpm.model.dmn.instance.Text;
import org.eximeebpms.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionDefinitionDeployerTest {
    protected static final String DMN_CHECK_ORDER_RESOURCE = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml";
    protected static final String DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn";
    protected static final String DMN_SCORE_RESOURCE = "org/eximeebpms/bpm/engine/test/dmn/deployment/dmnScore.dmn11.xml";
    protected static final String DMN_DECISION_LITERAL_EXPRESSION = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionWithLiteralExpression.dmn";
    protected static final String DRD_SCORE_RESOURCE = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_SCORE_V2_RESOURCE = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdScore_v2.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void dmnDeployment() {
        String deploymentId = this.testRule.deploy(DMN_CHECK_ORDER_RESOURCE).getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        Assert.assertEquals((Object)"http://camunda.org/schema/1.0/dmn", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((Object)"CheckOrder", (Object)decisionDefinition.getName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_CHECK_ORDER_RESOURCE, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionDefinition.getDiagramResourceName());
    }

    @Test
    public void dmnDeploymentWithDmnSuffix() {
        String deploymentId = this.testRule.deploy(DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX).getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        Assert.assertEquals((Object)"http://camunda.org/schema/1.0/dmn", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((Object)"CheckOrder", (Object)decisionDefinition.getName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionDefinition.getDiagramResourceName());
    }

    @Test
    public void dmnDeploymentWithDecisionLiteralExpression() {
        String deploymentId = this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION).getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("decisionLiteralExpression:1:"));
        Assert.assertEquals((Object)"http://camunda.org/schema/1.0/dmn", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((Object)"decisionLiteralExpression", (Object)decisionDefinition.getKey());
        Assert.assertEquals((Object)"Decision with Literal Expression", (Object)decisionDefinition.getName());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_DECISION_LITERAL_EXPRESSION, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionDefinition.getDiagramResourceName());
    }

    @Deployment
    @Test
    public void longDecisionDefinitionKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertFalse((boolean)decisionDefinition.getId().startsWith("o123456789"));
        Assert.assertEquals((Object)"o123456789o123456789o123456789o123456789o123456789o123456789o123456789", (Object)decisionDefinition.getKey());
    }

    @Test
    public void duplicateIdInDeployment() {
        String resourceName1 = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDuplicateIdInDeployment.dmn11.xml";
        String resourceName2 = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDuplicateIdInDeployment2.dmn11.xml";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().addClasspathResource(resourceName1).addClasspathResource(resourceName2).name("duplicateIds").deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("duplicateDecision");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource.dmn11.xml", "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource.png"})
    @Test
    public void getDecisionDiagramResource() {
        String resourcePrefix = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource";
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertEquals((Object)(resourcePrefix + ".dmn11.xml"), (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        String diagramResourceName = decisionDefinition.getDiagramResourceName();
        Assert.assertEquals((Object)(resourcePrefix + ".png"), (Object)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(decisionDefinition.getDeploymentId(), diagramResourceName);
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        Assert.assertEquals((long)2540L, (long)diagramBytes.length);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.dmn11.xml", "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision1.png", "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision2.png", "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision3.png"})
    @Test
    public void multipleDiagramResourcesProvided() {
        String resourcePrefix = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.";
        DecisionDefinitionQuery decisionDefinitionQuery = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)3L, (long)decisionDefinitionQuery.count());
        for (DecisionDefinition decisionDefinition : decisionDefinitionQuery.list()) {
            Assert.assertEquals((Object)(resourcePrefix + decisionDefinition.getKey() + ".png"), (Object)decisionDefinition.getDiagramResourceName());
        }
    }

    @Test
    public void drdDeployment() {
        String deploymentId = this.testRule.deploy(DRD_SCORE_RESOURCE).getId();
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionRequirementsDefinition.getId().startsWith("score:1:"));
        Assert.assertEquals((Object)"score", (Object)decisionRequirementsDefinition.getKey());
        Assert.assertEquals((Object)"Score", (Object)decisionRequirementsDefinition.getName());
        Assert.assertEquals((Object)"test-drd-1", (Object)decisionRequirementsDefinition.getCategory());
        Assert.assertEquals((long)1L, (long)decisionRequirementsDefinition.getVersion());
        Assert.assertEquals((Object)DRD_SCORE_RESOURCE, (Object)decisionRequirementsDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionRequirementsDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionRequirementsDefinition.getDiagramResourceName());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionKey().asc()).list();
        Assert.assertEquals((long)2L, (long)decisions.size());
        DecisionDefinition firstDecision = (DecisionDefinition)decisions.get(0);
        Assert.assertEquals((Object)"score-decision", (Object)firstDecision.getKey());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)firstDecision.getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)"score", (Object)firstDecision.getDecisionRequirementsDefinitionKey());
        DecisionDefinition secondDecision = (DecisionDefinition)decisions.get(1);
        Assert.assertEquals((Object)"score-result", (Object)secondDecision.getKey());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)secondDecision.getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)"score", (Object)secondDecision.getDecisionRequirementsDefinitionKey());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml"})
    @Test
    public void noDrdForSingleDecisionDeployment() {
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDecisionDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDecisionRequirementsDefinitionQuery().count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertNull((Object)decisionDefinition.getDecisionRequirementsDefinitionId());
        Assert.assertNull((Object)decisionDefinition.getDecisionRequirementsDefinitionKey());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml", "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void multipleDrdDeployment() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().asc()).list();
        Assert.assertEquals((long)2L, (long)decisionRequirementsDefinitions.size());
        Assert.assertEquals((Object)"score", (Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey());
        Assert.assertEquals((Object)"dish", (Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionCategory().asc()).list();
        Assert.assertEquals((long)5L, (long)decisions.size());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Object)((DecisionDefinition)decisions.get(0)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Object)((DecisionDefinition)decisions.get(1)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(2)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(3)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(4)).getDecisionRequirementsDefinitionId());
    }

    @Test
    public void duplicateDrdIdInDeployment() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().addClasspathResource(DRD_SCORE_RESOURCE).addClasspathResource(DRD_SCORE_V2_RESOURCE).name("duplicateIds").deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("definitions");
    }

    @Test
    public void deployMultipleDecisionsWithSameDrdId() {
        this.testRule.deploy(DMN_SCORE_RESOURCE, DMN_CHECK_ORDER_RESOURCE);
        Assert.assertEquals((long)2L, (long)this.repositoryService.createDecisionDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDecisionRequirementsDefinitionQuery().count());
    }

    @Test
    public void deployDecisionIndependentFromDrd() {
        String deploymentIdDecision = this.testRule.deploy(DMN_SCORE_RESOURCE).getId();
        String deploymentIdDrd = this.testRule.deploy(DRD_SCORE_RESOURCE).getId();
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertEquals((long)1L, (long)decisionRequirementsDefinition.getVersion());
        Assert.assertEquals((Object)deploymentIdDrd, (Object)decisionRequirementsDefinition.getDeploymentId());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("score-decision").orderByDecisionDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)decisions.size());
        DecisionDefinition firstDecision = (DecisionDefinition)decisions.get(0);
        Assert.assertEquals((long)1L, (long)firstDecision.getVersion());
        Assert.assertEquals((Object)deploymentIdDecision, (Object)firstDecision.getDeploymentId());
        Assert.assertNull((Object)firstDecision.getDecisionRequirementsDefinitionId());
        DecisionDefinition secondDecision = (DecisionDefinition)decisions.get(1);
        Assert.assertEquals((long)2L, (long)secondDecision.getVersion());
        Assert.assertEquals((Object)deploymentIdDrd, (Object)secondDecision.getDeploymentId());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)secondDecision.getDecisionRequirementsDefinitionId());
    }

    @Test
    public void testDeployDmnModelInstance() throws Exception {
        DmnModelInstance dmnModelInstance = DecisionDefinitionDeployerTest.createDmnModelInstance();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.dmn", dmnModelInstance));
        Assert.assertNotNull((Object)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionResourceName("foo.dmn").singleResult());
    }

    @Test
    public void testDeployDmnModelInstanceNegativeHistoryTimeToLive() throws Exception {
        DmnModelInstance dmnModelInstance = DecisionDefinitionDeployerTest.createDmnModelInstanceNegativeHistoryTimeToLive();
        try {
            this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.dmn", dmnModelInstance));
            Assert.fail((String)"Exception for negative time to live value is expected.");
        }
        catch (ProcessEngineException ex) {
            Assert.assertTrue((boolean)ex.getCause().getMessage().contains("negative value is not allowed"));
        }
    }

    protected static DmnModelInstance createDmnModelInstanceNegativeHistoryTimeToLive() {
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setId("definitions");
        definitions.setName("definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        Decision decision = (Decision)modelInstance.newInstance(Decision.class);
        decision.setId("Decision-1");
        decision.setName("foo");
        decision.setCamundaHistoryTimeToLive(Integer.valueOf(-5));
        modelInstance.getDefinitions().addChildElement((ModelElementInstance)decision);
        return modelInstance;
    }

    protected static DmnModelInstance createDmnModelInstance() {
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setId("definitions");
        definitions.setName("definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        Decision decision = (Decision)modelInstance.newInstance(Decision.class);
        decision.setId("Decision-1");
        decision.setName("foo");
        decision.setCamundaHistoryTimeToLive(Integer.valueOf(5));
        modelInstance.getDefinitions().addChildElement((ModelElementInstance)decision);
        DecisionTable decisionTable = (DecisionTable)modelInstance.newInstance(DecisionTable.class);
        decisionTable.setId("decisionTable");
        decisionTable.setHitPolicy(HitPolicy.FIRST);
        decision.addChildElement((ModelElementInstance)decisionTable);
        Input input = (Input)modelInstance.newInstance(Input.class);
        input.setId("Input-1");
        input.setLabel("Input");
        decisionTable.addChildElement((ModelElementInstance)input);
        InputExpression inputExpression = (InputExpression)modelInstance.newInstance(InputExpression.class);
        inputExpression.setId("InputExpression-1");
        Text inputExpressionText = (Text)modelInstance.newInstance(Text.class);
        inputExpressionText.setTextContent("input");
        inputExpression.setText(inputExpressionText);
        inputExpression.setTypeRef("string");
        input.setInputExpression(inputExpression);
        Output output = (Output)modelInstance.newInstance(Output.class);
        output.setName("output");
        output.setLabel("Output");
        output.setTypeRef("string");
        decisionTable.addChildElement((ModelElementInstance)output);
        return modelInstance;
    }

    @Test
    public void testDeployAndGetDecisionDefinition() throws Exception {
        DmnModelInstance dmnModelInstance = DecisionDefinitionDeployerTest.createDmnModelInstance();
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", dmnModelInstance);
        Object deployment = this.testRule.deploy(deploymentBuilder);
        List deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions();
        Assert.assertEquals((long)1L, (long)deployedDecisionDefinitions.size());
        Assert.assertNull((Object)deployment.getDeployedDecisionRequirementsDefinitions());
        Assert.assertNull((Object)deployment.getDeployedProcessDefinitions());
        Assert.assertNull((Object)deployment.getDeployedCaseDefinitions());
        DecisionDefinition persistedDecisionDef = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionResourceName("foo.dmn").singleResult();
        Assert.assertEquals((Object)persistedDecisionDef.getId(), (Object)((DecisionDefinition)deployedDecisionDefinitions.get(0)).getId());
    }

    @Test
    public void testDeployEmptyDecisionDefinition() throws Exception {
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setId("definitions");
        definitions.setName("definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", modelInstance);
        Object deployment = this.testRule.deploy(deploymentBuilder);
        Assert.assertNull((Object)deployment.getDeployedDecisionDefinitions());
        Assert.assertNull((Object)deployment.getDeployedDecisionRequirementsDefinitions());
        Assert.assertNull((Object)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionResourceName("foo.dmn").singleResult());
    }

    @Test
    public void testDeployAndGetDRDDefinition() throws Exception {
        DeploymentWithDefinitions deployment = this.testRule.deploy(DRD_SCORE_RESOURCE);
        List deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions();
        Assert.assertEquals((long)2L, (long)deployedDecisionDefinitions.size());
        List deployedDecisionRequirementsDefinitions = deployment.getDeployedDecisionRequirementsDefinitions();
        Assert.assertEquals((long)1L, (long)deployedDecisionRequirementsDefinitions.size());
        Assert.assertNull((Object)deployment.getDeployedProcessDefinitions());
        Assert.assertNull((Object)deployment.getDeployedCaseDefinitions());
        DecisionRequirementsDefinition persistedDecisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionResourceName(DRD_SCORE_RESOURCE).singleResult();
        Assert.assertEquals((Object)persistedDecisionRequirementsDefinition.getId(), (Object)((DecisionRequirementsDefinition)deployedDecisionRequirementsDefinitions.get(0)).getId());
        List persistedDecisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionResourceName(DRD_SCORE_RESOURCE).list();
        Assert.assertEquals((long)deployedDecisionDefinitions.size(), (long)persistedDecisionDefinitions.size());
    }

    @Test
    public void testDeployDecisionDefinitionWithIntegerHistoryTimeToLive() {
        DeploymentWithDefinitions deployment = this.testRule.deploy("org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDefinitionWithIntegerHistoryTimeToLive.dmn11.xml");
        List deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions();
        Assert.assertEquals((long)deployedDecisionDefinitions.size(), (long)1L);
        Integer historyTimeToLive = ((DecisionDefinition)deployedDecisionDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNotNull((Object)historyTimeToLive);
        Assert.assertEquals((long)historyTimeToLive.intValue(), (long)5L);
    }

    @Test
    public void testDeployDecisionDefinitionWithStringHistoryTimeToLive() {
        DeploymentWithDefinitions deployment = this.testRule.deploy("org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDefinitionWithStringHistoryTimeToLive.dmn11.xml");
        List deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions();
        Assert.assertEquals((long)deployedDecisionDefinitions.size(), (long)1L);
        Integer historyTimeToLive = ((DecisionDefinition)deployedDecisionDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNotNull((Object)historyTimeToLive);
        Assert.assertEquals((long)historyTimeToLive.intValue(), (long)5L);
    }

    @Test
    public void testDeployDecisionDefinitionWithMalformedStringHistoryTimeToLive() {
        try {
            this.testRule.deploy("org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDefinitionWithMalformedHistoryTimeToLive.dmn11.xml");
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Cannot parse historyTimeToLive"));
        }
    }

    @Test
    public void testDeployDecisionDefinitionWithEmptyHistoryTimeToLive() {
        DeploymentWithDefinitions deployment = this.testRule.deploy("org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDefinitionWithEmptyHistoryTimeToLive.dmn11.xml");
        List deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions();
        Assert.assertEquals((long)deployedDecisionDefinitions.size(), (long)1L);
        Integer historyTimeToLive = ((DecisionDefinition)deployedDecisionDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNull((Object)historyTimeToLive);
    }
}

