/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.dmn.feel;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.dmn.feel.helper.CustomFunctionProvider;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class FeelCustomFunctionConfigTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        ArrayList<CustomFunctionProvider> customFunctionProviders = new ArrayList<CustomFunctionProvider>();
        customFunctionProviders.add(new CustomFunctionProvider("myFunctionOne", "foo"));
        customFunctionProviders.add(new CustomFunctionProvider("myFunctionTwo", "bar"));
        configuration.setDmnFeelCustomFunctionProviders(customFunctionProviders);
    });
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected String deploymentId;

    @Before
    public void setup() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.repositoryService = this.processEngine.getRepositoryService();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/feel/custom_function.dmn"})
    public void shouldRegisterCustomFunctions() {
        DecisionService decisionService = this.processEngine.getDecisionService();
        String result = (String)decisionService.evaluateDecisionByKey("c").evaluate().getSingleEntry();
        Assertions.assertThat((String)result).isEqualTo((Object)"foobar");
    }
}

