/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.history.handler.DbHistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.history.AbstractCompositeHistoryEventHandlerTest;
import org.junit.Test;

public class CompositeHistoryEventHandlerTest
extends AbstractCompositeHistoryEventHandlerTest {
    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerNonArgumentConstructor() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new CompositeHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isZero();
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isZero();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseDefaultHistoryEventHandler() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new DbHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isZero();
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    public void shouldUseCompositeHistoryEventHandlerNonArgumentConstructorAddNullEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        try {
            compositeHistoryEventHandler.add(null);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerNonArgumentConstructorAddNotNullEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        compositeHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(0L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerNonArgumentConstructorAddNotNullTwoEvents() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler();
        compositeHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        compositeHistoryEventHandler.add((HistoryEventHandler)new DbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNullVarargs() {
        Object historyEventHandler = null;
        try {
            new CompositeHistoryEventHandler(new HistoryEventHandler[]{historyEventHandler});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNullTwoVarargs() {
        try {
            new CompositeHistoryEventHandler(new HistoryEventHandler[]{null, null});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNotNullVarargsOneEvent() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isZero();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNotNullVarargsTwoEvents() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler(), new DbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithEmptyList() {
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(new ArrayList());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isZero();
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isZero();
    }

    @Test
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNotEmptyListNullTwoEvents() {
        ArrayList<Object> historyEventHandlers = new ArrayList<Object>();
        historyEventHandlers.add(null);
        historyEventHandlers.add(null);
        try {
            new CompositeHistoryEventHandler(historyEventHandlers);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeHistoryEventHandlerArgumentConstructorWithNotEmptyListNotNullTwoEvents() {
        ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler> historyEventHandlers = new ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler>();
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        historyEventHandlers.add((AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler)new DbHistoryEventHandler());
        CompositeHistoryEventHandler compositeHistoryEventHandler = new CompositeHistoryEventHandler(historyEventHandlers);
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }
}

