/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.EventSubscriptionQuery;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricActivityInstanceTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testHistoricActivityInstanceNoop() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noopProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").singleResult();
        Assert.assertEquals((Object)"noop", (Object)historicActivityInstance.getActivityId());
        Assert.assertEquals((Object)"serviceTask", (Object)historicActivityInstance.getActivityType());
        Assert.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getExecutionId());
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        Assert.assertNotNull((Object)historicActivityInstance.getEndTime());
        Assert.assertTrue((historicActivityInstance.getDurationInMillis() >= 0L ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceReceive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        Assert.assertEquals((Object)"receive", (Object)historicActivityInstance.getActivityId());
        Assert.assertEquals((Object)"receiveTask", (Object)historicActivityInstance.getActivityType());
        Assert.assertNull((Object)historicActivityInstance.getEndTime());
        Assert.assertNull((Object)historicActivityInstance.getDurationInMillis());
        Assert.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getExecutionId());
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        Date now = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 1000L));
        this.runtimeService.signal(processInstance.getId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        Assert.assertEquals((Object)"receive", (Object)historicActivityInstance.getActivityId());
        Assert.assertEquals((Object)"receiveTask", (Object)historicActivityInstance.getActivityType());
        Assert.assertNotNull((Object)historicActivityInstance.getEndTime());
        Assert.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getExecutionId());
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        Assert.assertTrue((historicActivityInstance.getDurationInMillis() >= 1000L ? 1 : 0) != 0);
        Assert.assertTrue((((HistoricActivityInstanceEventEntity)historicActivityInstance).getDurationRaw() >= 1000L ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceReceive.bpmn20.xml"})
    @Test
    public void testLongRunningHistoricActivityInstanceReceive() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        ClockUtil.setCurrentTime((Date)cal.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        Assert.assertEquals((Object)"receive", (Object)historicActivityInstance.getActivityId());
        Assert.assertEquals((Object)"receiveTask", (Object)historicActivityInstance.getActivityType());
        Assert.assertNull((Object)historicActivityInstance.getEndTime());
        Assert.assertNull((Object)historicActivityInstance.getDurationInMillis());
        Assert.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getExecutionId());
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        cal.add(1, 1);
        ClockUtil.setCurrentTime((Date)cal.getTime());
        this.runtimeService.signal(processInstance.getId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        Assert.assertEquals((Object)"receive", (Object)historicActivityInstance.getActivityId());
        Assert.assertEquals((Object)"receiveTask", (Object)historicActivityInstance.getActivityType());
        Assert.assertNotNull((Object)historicActivityInstance.getEndTime());
        Assert.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicActivityInstance.getExecutionId());
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        Assert.assertTrue((historicActivityInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        Assert.assertTrue((((HistoricActivityInstanceEventEntity)historicActivityInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noopProcess");
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("nonExistingActivityId").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityType("nonExistingActivityType").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityType("serviceTask").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityName("nonExistingActivityName").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityName("No operation").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityNameLike("operation").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityNameLike("%operation").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityNameLike("%oper%").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().taskAssignee("nonExistingAssignee").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().executionId("nonExistingExecutionId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().executionId(processInstance.getId()).list().size());
        } else {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().executionId(processInstance.getId()).list().size());
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId("nonExistingProcessInstanceId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        } else {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId("nonExistingProcessDefinitionId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list().size());
        } else {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list().size());
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().unfinished().list().size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().finished().list().size());
        } else {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().finished().list().size());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().list().get(0);
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicActivityInstance.getId()).list().size());
        }
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceForEventsQuery() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("eventProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.signalEventReceived("signal");
        this.testRule.assertProcessEnded(pi.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("intermediate-event").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("start").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("end").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("boundaryEvent").list().size());
        HistoricActivityInstance intermediateEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("intermediate-event").singleResult();
        Assert.assertNotNull((Object)intermediateEvent.getStartTime());
        Assert.assertNotNull((Object)intermediateEvent.getEndTime());
        HistoricActivityInstance startEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("start").singleResult();
        Assert.assertNotNull((Object)startEvent.getStartTime());
        Assert.assertNotNull((Object)startEvent.getEndTime());
        HistoricActivityInstance endEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("end").singleResult();
        Assert.assertNotNull((Object)endEvent.getStartTime());
        Assert.assertNotNull((Object)endEvent.getEndTime());
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceProperties() {
        this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)task.getId(), (Object)historicActivityInstance.getTaskId());
        Assert.assertEquals((Object)"kermit", (Object)historicActivityInstance.getAssignee());
        this.taskService.setAssignee(task.getId(), "gonzo");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult();
        Assert.assertEquals((Object)"gonzo", (Object)historicActivityInstance.getAssignee());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/calledProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testCallSimpleSubProcess.bpmn20.xml"})
    @Test
    public void testHistoricActivityInstanceCalledProcessId() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("callSubProcess").singleResult();
        HistoricProcessInstance oldInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("calledProcess").singleResult();
        Assert.assertEquals((Object)oldInstance.getId(), (Object)historicActivityInstance.getCalledProcessInstanceId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/calledProcessWaiting.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testCallSimpleSubProcess.bpmn20.xml"})
    @Test
    public void testHistoricActivityInstanceCalledProcessIdWithWaitState() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("calledProcess").singleResult();
        HistoricActivityInstanceQuery activityQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("callSubProcess");
        Assert.assertEquals((Object)calledInstance.getId(), (Object)((HistoricActivityInstance)activityQuery.singleResult()).getCalledProcessInstanceId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(calledInstance.getId()).singleResult()).getId());
        Assert.assertEquals((Object)calledInstance.getId(), (Object)((HistoricActivityInstance)activityQuery.singleResult()).getCalledProcessInstanceId());
    }

    @Deployment
    @Test
    public void testSorting() {
        this.runtimeService.startProcessInstanceByKey("process");
        int expectedActivityInstances = -1;
        expectedActivityInstances = this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY ? 2 : 0;
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().desc()).count());
        Assert.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().desc()).count());
    }

    @Test
    public void testInvalidSorting() {
        try {
            ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().asc()).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().desc()).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricActivityInstanceQueryStartFinishAfterBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey123");
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourAgo.getTime()).finishedAfter(hourFromNow.getTime()).count());
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceQueryByCompleteScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().completeScope();
        Assert.assertEquals((long)3L, (long)query.count());
        List instances = query.list();
        for (HistoricActivityInstance instance : instances) {
            if (instance.getActivityId().equals("innerEnd") || instance.getActivityId().equals("end1") || instance.getActivityId().equals("end2")) continue;
            Assert.fail((String)("Unexpected instance with activity id " + instance.getActivityId() + " found."));
        }
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceQueryByCompleteScope.bpmn"})
    @Test
    public void testHistoricActivityInstanceQueryByCanceled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().canceled();
        Assert.assertEquals((long)3L, (long)query.count());
        List instances = query.list();
        for (HistoricActivityInstance instance : instances) {
            if (instance.getActivityId().equals("subprocess") || instance.getActivityId().equals("userTask1") || instance.getActivityId().equals("userTask2")) continue;
            Assert.fail((String)("Unexpected instance with activity id " + instance.getActivityId() + " found."));
        }
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testHistoricActivityInstanceQueryByCompleteScopeAndCanceled() {
        try {
            this.historyService.createHistoricActivityInstanceQuery().completeScope().canceled().list();
            Assert.fail((String)"It should not be possible to query by completeScope and canceled.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceGatewayEndTimes() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("gatewayEndTimes");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Assert.assertNotNull((Object)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult()).getEndTime());
        Assert.assertNotNull((Object)((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("Gateway_0").singleResult()).getEndTime());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("Gateway_1");
        Assert.assertEquals((long)2L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.list().get(0)).getEndTime());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.list().get(1)).getEndTime());
    }

    @Deployment
    @Test
    public void testHistoricActivityInstanceTimerEvent() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job timer = (Job)jobQuery.singleResult();
        this.managementService.executeJob(timer.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"afterTimer", (Object)task.getName());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("gw1");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("timerEvent");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        Assert.assertEquals((Object)"intermediateTimer", (Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceTimerEvent.bpmn20.xml"})
    @Test
    public void testHistoricActivityInstanceMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Assert.assertEquals((long)1L, (long)eventSubscriptionQuery.count());
        this.runtimeService.correlateMessage("newInvoice");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"afterMessage", (Object)task.getName());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("gw1");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("messageEvent");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        Assert.assertEquals((Object)"intermediateMessageCatch", (Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getActivityType());
    }

    @Deployment
    @Test
    public void testUserTaskStillRunning() {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingEvent");
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)jobQuery.singleResult()).getId());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("userTask");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("end1");
        Assert.assertEquals((long)0L, (long)historicActivityInstanceQuery.count());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("timer");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("end2");
        Assert.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
    }

    @Deployment
    @Test
    public void testInterruptingBoundaryMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        this.runtimeService.messageEventReceived("newMessage", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("message");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundaryMessage", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingBoundaryMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        this.runtimeService.messageEventReceived("newMessage", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("message");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundaryMessage", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testInterruptingBoundarySignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("newSignal").singleResult();
        this.runtimeService.signalEventReceived("newSignal", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("signal");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundarySignal", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingBoundarySignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("newSignal").singleResult();
        this.runtimeService.signalEventReceived("newSignal", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("signal");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundarySignal", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testInterruptingBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("timer");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundaryTimer", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("timer");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundaryTimer", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testBoundaryErrorEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("error");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"boundaryError", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testBoundaryCancelEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("catchCancel");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Assert.assertEquals((Object)"cancelBoundaryCatch", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testBoundaryCompensateEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("compensate");
        Assert.assertEquals((long)0L, (long)query.count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testBoundaryCompensateEvent.bpmn20.xml"})
    @Test
    public void testCompensationServiceTaskHasEndTime() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("compensationServiceTask");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testBoundaryCancelEvent.bpmn20.xml"})
    @Test
    public void testTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("transaction");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testScopeActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("userTask");
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)query.singleResult();
        Assert.assertEquals((Object)pi.getId(), (Object)historicActivityInstance.getParentActivityInstanceId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultiInstanceScopeActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        HistoricActivityInstance miBodyInstance = (HistoricActivityInstance)query.activityId("userTask#multiInstanceBody").singleResult();
        query.activityId("userTask");
        Assert.assertEquals((long)5L, (long)query.count());
        List result = query.list();
        for (HistoricActivityInstance instance : result) {
            Assert.assertEquals((Object)miBodyInstance.getId(), (Object)instance.getParentActivityInstanceId());
        }
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultiInstanceReceiveActivity() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        HistoricActivityInstance miBodyInstance = (HistoricActivityInstance)query.activityId("receiveTask#multiInstanceBody").singleResult();
        query.activityId("receiveTask");
        Assert.assertEquals((long)5L, (long)query.count());
        List result = query.list();
        for (HistoricActivityInstance instance : result) {
            Assert.assertEquals((Object)miBodyInstance.getId(), (Object)instance.getParentActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testEvents.bpmn"})
    @Test
    public void testIntermediateCatchEventTypes() {
        HistoricActivityInstanceQuery query = this.startEventTestProcess("");
        query.activityId("intermediateSignalCatchEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateSignalCatch", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("intermediateMessageCatchEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateMessageCatch", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("intermediateTimerCatchEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateTimer", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testEvents.bpmn"})
    @Test
    public void testIntermediateThrowEventTypes() {
        HistoricActivityInstanceQuery query = this.startEventTestProcess("");
        query.activityId("intermediateSignalThrowEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateSignalThrow", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("intermediateMessageThrowEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateMessageThrowEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("intermediateNoneThrowEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateNoneThrowEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("intermediateCompensationThrowEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"intermediateCompensationThrowEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testEvents.bpmn"})
    @Test
    public void testStartEventTypes() {
        HistoricActivityInstanceQuery query = this.startEventTestProcess("");
        query.activityId("timerStartEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"startTimerEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("noneStartEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"startEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query = this.startEventTestProcess("CAM-2365");
        query.activityId("messageStartEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"messageStartEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testEvents.bpmn"})
    @Test
    public void testEndEventTypes() {
        HistoricActivityInstanceQuery query = this.startEventTestProcess("");
        query.activityId("cancellationEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"cancelEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("messageEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"messageEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("errorEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"errorEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("signalEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"signalEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("terminationEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"terminateEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
        query.activityId("noneEndEvent");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"noneEndEvent", (Object)((HistoricActivityInstance)query.singleResult()).getActivityType());
    }

    private HistoricActivityInstanceQuery startEventTestProcess(String message) {
        if (message.equals("")) {
            this.runtimeService.startProcessInstanceByKey("testEvents");
        } else {
            this.runtimeService.startProcessInstanceByMessage("CAM-2365");
        }
        return this.historyService.createHistoricActivityInstanceQuery();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.startEventTypesForEventSubprocess.bpmn20.xml"})
    @Test
    public void testMessageEventSubprocess() {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("shouldThrowError", false);
        this.runtimeService.startProcessInstanceByKey("process", vars);
        this.runtimeService.correlateMessage("newMessage");
        HistoricActivityInstance historicActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("messageStartEvent").singleResult();
        Assert.assertEquals((Object)"messageStartEvent", (Object)historicActivity.getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.startEventTypesForEventSubprocess.bpmn20.xml"})
    @Test
    public void testSignalEventSubprocess() {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("shouldThrowError", false);
        this.runtimeService.startProcessInstanceByKey("process", vars);
        this.runtimeService.signalEventReceived("newSignal");
        HistoricActivityInstance historicActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("signalStartEvent").singleResult();
        Assert.assertEquals((Object)"signalStartEvent", (Object)historicActivity.getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.startEventTypesForEventSubprocess.bpmn20.xml"})
    @Test
    public void testTimerEventSubprocess() {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("shouldThrowError", false);
        this.runtimeService.startProcessInstanceByKey("process", vars);
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timerJob.getId());
        HistoricActivityInstance historicActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("timerStartEvent").singleResult();
        Assert.assertEquals((Object)"startTimerEvent", (Object)historicActivity.getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.startEventTypesForEventSubprocess.bpmn20.xml"})
    @Test
    public void testErrorEventSubprocess() {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("shouldThrowError", true);
        this.runtimeService.startProcessInstanceByKey("process", vars);
        HistoricActivityInstance historicActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("errorStartEvent").singleResult();
        Assert.assertEquals((Object)"errorStartEvent", (Object)historicActivity.getActivityType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testCaseCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseCallActivity() {
        this.runtimeService.startProcessInstanceByKey("process");
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().singleResult()).getId();
        HistoricActivityInstance historicCallActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("callActivity").singleResult();
        Assert.assertEquals((Object)subCaseInstanceId, (Object)historicCallActivity.getCalledCaseInstanceId());
        Assert.assertNull((Object)historicCallActivity.getEndTime());
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTaskId);
        historicCallActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("callActivity").singleResult();
        Assert.assertEquals((Object)subCaseInstanceId, (Object)historicCallActivity.getCalledCaseInstanceId());
        Assert.assertNotNull((Object)historicCallActivity.getEndTime());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricActivityInstance activityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId("theTask").singleResult();
        Assert.assertNotNull((Object)activityInstance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)activityInstance.getProcessDefinitionKey());
    }

    @Deployment
    @Test
    public void testEndParallelJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activityInstance = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi.getId()).activityId("parallelJoinEnd").list();
        Assertions.assertThat((int)activityInstance.size()).isEqualTo(2);
        Assertions.assertThat((boolean)pi.isEnded()).isTrue();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceProperties.bpmn20.xml"})
    @Test
    public void testAssigneeSavedWhenTaskSaved() {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().activityId("theTask");
        this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)query.singleResult();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"kermit", (Object)historicActivityInstance.getAssignee());
        task.setAssignee("gonzo");
        this.taskService.saveTask(task);
        historicActivityInstance = (HistoricActivityInstance)query.singleResult();
        Assert.assertEquals((Object)"gonzo", (Object)historicActivityInstance.getAssignee());
    }
}

