/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.history.HistoricJobLogQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricJobLogQueryTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected String defaultHostname;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.defaultHostname = this.processEngineConfiguration.getHostname();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setHostname(this.defaultHostname);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQuery() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByLogId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String logId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().logId(logId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidLogId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().logId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.logId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByJobId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidJobId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByJobExceptionMessage() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobExceptionMessage("Expected_exception.");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidJobExceptionMessage() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobExceptionMessage("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobExceptionMessage(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByFailedActivityId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().failedActivityIdIn(new String[]{"serviceTask"});
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidFailedActivityId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().failedActivityIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        String[] nullValue = null;
        try {
            query.failedActivityIdIn(nullValue);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] activityIdsContainsNull = new String[]{"a", null, "b"};
        try {
            query.failedActivityIdIn(activityIdsContainsNull);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] activityIdsContainsEmptyString = new String[]{"a", "", "b"};
        try {
            query.failedActivityIdIn(activityIdsContainsEmptyString);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobDefinitionId = ((Job)this.managementService.createJobQuery().singleResult()).getJobDefinitionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionId(jobDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidJobDefinitionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByJobDefinitionType() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionType("async-continuation");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidJobDefinitionType() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionType(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByJobDefinitionConfiguration() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration("async-before");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidJobDefinitionConfiguration() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionConfiguration(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByActivityId() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().activityIdIn(new String[]{"serviceTask"});
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidActivityId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().activityIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        String[] nullValue = null;
        try {
            query.activityIdIn(nullValue);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] activityIdsContainsNull = new String[]{"a", null, "b"};
        try {
            query.activityIdIn(activityIdsContainsNull);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] activityIdsContainsEmptyString = new String[]{"a", "", "b"};
        try {
            query.activityIdIn(activityIdsContainsEmptyString);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByExecutionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String executionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().executionIdIn(new String[]{executionId});
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidExecutionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().executionIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        String[] nullValue = null;
        try {
            query.executionIdIn(nullValue);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] executionIdsContainsNull = new String[]{"a", null, "b"};
        try {
            query.executionIdIn(executionIdsContainsNull);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] executionIdsContainsEmptyString = new String[]{"a", "", "b"};
        try {
            query.executionIdIn(executionIdsContainsEmptyString);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = ((Job)this.managementService.createJobQuery().singleResult()).getProcessInstanceId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidProcessInstanceId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processInstanceId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processDefinitionId = ((Job)this.managementService.createJobQuery().singleResult()).getProcessDefinitionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionId(processDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidProcessDefinitionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processDefinitionId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionKey() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processDefinitionKey = ((Job)this.managementService.createJobQuery().singleResult()).getProcessDefinitionKey();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionKey(processDefinitionKey);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidProcessDefinitionKey() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processDefinitionKey(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByDeploymentId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String deploymentId = ((Job)this.managementService.createJobQuery().singleResult()).getDeploymentId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deploymentId(deploymentId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void shouldQueryCreateLogByHostname() {
        String testHostname1 = "HOST_1";
        this.processEngineConfiguration.setHostname(testHostname1);
        this.startProcessInstanceWithJob(false);
        String testHostname2 = "HOST_2";
        this.processEngineConfiguration.setHostname(testHostname2);
        this.startProcessInstanceWithJob(false);
        HistoricJobLogQuery query1 = this.historyService.createHistoricJobLogQuery().creationLog().hostname(testHostname1);
        HistoricJobLogQuery query2 = this.historyService.createHistoricJobLogQuery().creationLog().hostname(testHostname2);
        this.verifyQueryResults(query1, 1);
        this.verifyQueryResults(query2, 1);
        Assertions.assertThat((String)((HistoricJobLog)query1.singleResult()).getHostname()).isNotEqualToIgnoringCase((CharSequence)((HistoricJobLog)query2.singleResult()).getHostname());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void shouldQuerySuccessLogByHostname() {
        String testHostname1 = "HOST_1";
        this.processEngineConfiguration.setHostname(testHostname1);
        this.startProcessInstanceWithJobAndCompleteJob(false);
        String testHostname2 = "HOST_2";
        this.processEngineConfiguration.setHostname(testHostname2);
        this.startProcessInstanceWithJobAndCompleteJob(false);
        HistoricJobLogQuery query1 = this.historyService.createHistoricJobLogQuery().successLog().hostname(testHostname1);
        HistoricJobLogQuery query2 = this.historyService.createHistoricJobLogQuery().successLog().hostname(testHostname2);
        this.verifyQueryResults(query1, 1);
        this.verifyQueryResults(query2, 1);
        Assertions.assertThat((String)((HistoricJobLog)query1.singleResult()).getHostname()).isNotEqualToIgnoringCase((CharSequence)((HistoricJobLog)query2.singleResult()).getHostname());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void shouldQueryFailureLogByHostname() {
        String testHostname1 = "HOST_1";
        this.processEngineConfiguration.setHostname(testHostname1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.startProcessInstanceWithJobAndCompleteJob(true)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Expected_exception");
        String testHostname2 = "HOST_2";
        this.processEngineConfiguration.setHostname(testHostname2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.startProcessInstanceWithJobAndCompleteJob(true)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Expected_exception");
        HistoricJobLogQuery query1 = this.historyService.createHistoricJobLogQuery().failureLog().hostname(testHostname1);
        HistoricJobLogQuery query2 = this.historyService.createHistoricJobLogQuery().failureLog().hostname(testHostname2);
        this.verifyQueryResults(query1, 1);
        this.verifyQueryResults(query2, 1);
        Assertions.assertThat((String)((HistoricJobLog)query1.singleResult()).getHostname()).isNotEqualToIgnoringCase((CharSequence)((HistoricJobLog)query2.singleResult()).getHostname());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void shouldQueryDeletionLogByHostname() {
        String testHostname1 = "HOST_1";
        this.processEngineConfiguration.setHostname(testHostname1);
        String pId1 = this.startProcessInstanceWithJob(false);
        this.runtimeService.deleteProcessInstance(pId1, "delete job log");
        String testHostname2 = "HOST_2";
        this.processEngineConfiguration.setHostname(testHostname2);
        String pId2 = this.startProcessInstanceWithJob(false);
        this.runtimeService.deleteProcessInstance(pId2, "delete job log");
        HistoricJobLogQuery query1 = this.historyService.createHistoricJobLogQuery().deletionLog().hostname(testHostname1);
        HistoricJobLogQuery query2 = this.historyService.createHistoricJobLogQuery().deletionLog().hostname(testHostname2);
        this.verifyQueryResults(query1, 1);
        this.verifyQueryResults(query2, 1);
        Assertions.assertThat((String)((HistoricJobLog)query1.singleResult()).getHostname()).isNotEqualToIgnoringCase((CharSequence)((HistoricJobLog)query2.singleResult()).getHostname());
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testQueryByJobPriority() {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityLowerThanOrEquals(2L).orderByJobPriority().asc()).list();
        Assertions.assertThat((int)jobLogs.size()).isEqualTo(3);
        for (HistoricJobLog log : jobLogs) {
            Assertions.assertThat((log.getJobPriority() <= 2L ? 1 : 0) != 0).isTrue();
        }
        jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityHigherThanOrEquals(3L).orderByJobPriority().asc()).list();
        Assertions.assertThat((int)jobLogs.size()).isEqualTo(2);
        for (HistoricJobLog log : jobLogs) {
            Assertions.assertThat((log.getJobPriority() >= 3L ? 1 : 0) != 0).isTrue();
        }
        jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityHigherThanOrEquals(1L).jobPriorityLowerThanOrEquals(3L).orderByJobPriority().asc()).list();
        Assertions.assertThat((int)jobLogs.size()).isEqualTo(3);
        for (HistoricJobLog log : jobLogs) {
            Assertions.assertThat((log.getJobPriority() >= 1L && log.getJobPriority() <= 3L ? 1 : 0) != 0).isTrue();
        }
        jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityHigherThanOrEquals(3L).jobPriorityLowerThanOrEquals(1L).orderByJobPriority().asc()).list();
        Assertions.assertThat((int)jobLogs.size()).isEqualTo(0);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByCreationLog() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().creationLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByFailureLog() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().failureLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryBySuccessLog() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().successLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQueryByDeletionLog() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deletionLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQuerySorting() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        query.orderByTimestamp().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByTimestamp());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobDefinitionId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDueDate().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobDueDate());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobRetries().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobRetries());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByActivityId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByActivityId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByExecutionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByExecutionId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessInstanceId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessInstanceId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessDefinitionId());
        query = this.historyService.createHistoricJobLogQuery();
        ProcessEngine processEngine = this.engineRule.getProcessEngine();
        query.orderByProcessDefinitionKey().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessDefinitionKey(processEngine));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByDeploymentId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobPriority().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobPriority());
        query.orderByTimestamp().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByTimestamp()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobDefinitionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDueDate().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobDueDate()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobRetries().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobRetries()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByActivityId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByActivityId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByExecutionId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByExecutionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessInstanceId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessInstanceId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessDefinitionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionKey().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessDefinitionKey(processEngine)));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByDeploymentId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobPriority().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobPriority()));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testQuerySortingPartiallyByOccurrence() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.testRule.executeAvailableJobs();
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        HistoricJobLogQuery query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().asc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.historicJobLogPartiallyByOccurence());
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().desc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogPartiallyByOccurence()));
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.testRule.executeAvailableJobs();
        this.managementService.deleteJob(jobId);
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().asc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.historicJobLogPartiallyByOccurence());
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().desc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogPartiallyByOccurence()));
    }

    protected String startProcessInstanceWithJob(boolean failJob) {
        return this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)failJob)).getId();
    }

    protected void startProcessInstanceWithJobAndCompleteJob(boolean failJob) {
        String pId = this.startProcessInstanceWithJob(failJob);
        String jobId = ((Job)this.managementService.createJobQuery().processInstanceId(pId).singleResult()).getId();
        this.managementService.executeJob(jobId);
    }

    protected void verifyQueryResults(HistoricJobLogQuery query, int countExpected) {
        Assertions.assertThat((int)query.list().size()).isEqualTo(countExpected);
        Assertions.assertThat((long)query.count()).isEqualTo((long)countExpected);
        if (countExpected == 1) {
            Assertions.assertThat((Object)((HistoricJobLog)query.singleResult())).isNotNull();
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assertions.assertThat((Object)((HistoricJobLog)query.singleResult())).isNull();
        }
    }

    protected void verifyQueryWithOrdering(HistoricJobLogQuery query, int countExpected, TestOrderingUtil.NullTolerantComparator<HistoricJobLog> expectedOrdering) {
        this.verifyQueryResults(query, countExpected);
        TestOrderingUtil.verifySorting(query.list(), expectedOrdering);
    }

    protected void verifySingleResultFails(HistoricJobLogQuery query) {
        try {
            query.singleResult();
            Assertions.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

