/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.history.HistoricJobLogQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.ExceptionUtil;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.repository.ResourceType;
import org.eximeebpms.bpm.engine.repository.ResourceTypes;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.history.FirstFailingDelegate;
import org.eximeebpms.bpm.engine.test.history.SecondFailingDelegate;
import org.eximeebpms.bpm.engine.test.history.ThrowExceptionWithOverlongMessageDelegate;
import org.eximeebpms.bpm.engine.test.history.ThrowExceptionWithoutMessageDelegate;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ManualTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricJobLogTest {
    protected static final String CUSTOM_HOSTNAME = "TEST_HOST";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    private boolean defaultEnsureJobDueDateSet;
    protected String defaultHostname;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.defaultEnsureJobDueDateSet = this.processEngineConfiguration.isEnsureJobDueDateNotNull();
        this.defaultHostname = this.processEngineConfiguration.getHostname();
        this.processEngineConfiguration.setHostname(CUSTOM_HOSTNAME);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
        this.processEngineConfiguration.setHostname(this.defaultHostname);
        ClockUtil.reset();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testCreateHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().creationLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getTimestamp()).isNotNull();
        Assertions.assertThat((String)historicJob.getJobExceptionMessage()).isNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
        Assertions.assertThat((int)historicJob.getJobRetries()).isEqualTo(job.getRetries());
        Assertions.assertThat((String)historicJob.getExecutionId()).isEqualTo((Object)job.getExecutionId());
        Assertions.assertThat((String)historicJob.getProcessInstanceId()).isEqualTo((Object)job.getProcessInstanceId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionId()).isEqualTo((Object)job.getProcessDefinitionId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionKey()).isEqualTo((Object)job.getProcessDefinitionKey());
        Assertions.assertThat((String)historicJob.getDeploymentId()).isEqualTo((Object)job.getDeploymentId());
        Assertions.assertThat((long)historicJob.getJobPriority()).isEqualTo(job.getPriority());
        Assertions.assertThat((String)historicJob.getHostname()).containsIgnoringCase((CharSequence)CUSTOM_HOSTNAME);
        Assertions.assertThat((boolean)historicJob.isCreationLog()).isTrue();
        Assertions.assertThat((boolean)historicJob.isFailureLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isSuccessLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isDeletionLog()).isFalse();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testFailedHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (JobEntity)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getTimestamp()).isNotNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
        Assertions.assertThat((int)historicJob.getJobRetries()).isEqualTo(3);
        Assertions.assertThat((String)historicJob.getExecutionId()).isEqualTo((Object)job.getExecutionId());
        Assertions.assertThat((String)historicJob.getProcessInstanceId()).isEqualTo((Object)job.getProcessInstanceId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionId()).isEqualTo((Object)job.getProcessDefinitionId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionKey()).isEqualTo((Object)job.getProcessDefinitionKey());
        Assertions.assertThat((String)historicJob.getDeploymentId()).isEqualTo((Object)job.getDeploymentId());
        Assertions.assertThat((String)historicJob.getJobExceptionMessage()).isEqualTo((Object)"Expected_exception.");
        Assertions.assertThat((long)historicJob.getJobPriority()).isEqualTo(job.getPriority());
        Assertions.assertThat((String)historicJob.getHostname()).containsIgnoringCase((CharSequence)CUSTOM_HOSTNAME);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)historicJob.getFailedActivityId()).isNotNull()).isEqualTo((Object)job.getFailedActivityId());
        Assertions.assertThat((boolean)historicJob.isCreationLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isFailureLog()).isTrue();
        Assertions.assertThat((boolean)historicJob.isSuccessLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isDeletionLog()).isFalse();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testSuccessfulHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().successLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getTimestamp()).isNotNull();
        Assertions.assertThat((String)historicJob.getJobExceptionMessage()).isNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
        Assertions.assertThat((int)historicJob.getJobRetries()).isEqualTo(job.getRetries());
        Assertions.assertThat((String)historicJob.getExecutionId()).isEqualTo((Object)job.getExecutionId());
        Assertions.assertThat((String)historicJob.getProcessInstanceId()).isEqualTo((Object)job.getProcessInstanceId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionId()).isEqualTo((Object)job.getProcessDefinitionId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionKey()).isEqualTo((Object)job.getProcessDefinitionKey());
        Assertions.assertThat((String)historicJob.getDeploymentId()).isEqualTo((Object)job.getDeploymentId());
        Assertions.assertThat((long)historicJob.getJobPriority()).isEqualTo(job.getPriority());
        Assertions.assertThat((String)historicJob.getHostname()).containsIgnoringCase((CharSequence)CUSTOM_HOSTNAME);
        Assertions.assertThat((boolean)historicJob.isCreationLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isFailureLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isSuccessLog()).isTrue();
        Assertions.assertThat((boolean)historicJob.isDeletionLog()).isFalse();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testDeletedHistoricJobLogProperties() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().deletionLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getTimestamp()).isNotNull();
        Assertions.assertThat((String)historicJob.getJobExceptionMessage()).isNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
        Assertions.assertThat((int)historicJob.getJobRetries()).isEqualTo(job.getRetries());
        Assertions.assertThat((String)historicJob.getExecutionId()).isEqualTo((Object)job.getExecutionId());
        Assertions.assertThat((String)historicJob.getProcessInstanceId()).isEqualTo((Object)job.getProcessInstanceId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionId()).isEqualTo((Object)job.getProcessDefinitionId());
        Assertions.assertThat((String)historicJob.getProcessDefinitionKey()).isEqualTo((Object)job.getProcessDefinitionKey());
        Assertions.assertThat((String)historicJob.getDeploymentId()).isEqualTo((Object)job.getDeploymentId());
        Assertions.assertThat((long)historicJob.getJobPriority()).isEqualTo(job.getPriority());
        Assertions.assertThat((String)historicJob.getHostname()).containsIgnoringCase((CharSequence)CUSTOM_HOSTNAME);
        Assertions.assertThat((boolean)historicJob.isCreationLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isFailureLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isSuccessLog()).isFalse();
        Assertions.assertThat((boolean)historicJob.isDeletionLog()).isTrue();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testAsyncBeforeJobHandlerType() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isNull();
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testAsyncBeforeJobHandlerTypeDueDateSet() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(true);
        Date testDate = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)testDate);
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-before");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testAsyncAfterJobHandlerType() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Job anotherJob = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((boolean)job.getId().equals(anotherJob.getId())).isFalse();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(anotherJob.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isNull();
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)anotherJob.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-after");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testAsyncAfterJobHandlerTypeDueDateSet() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(true);
        Date testDate = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Job anotherJob = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((boolean)job.getId().equals(anotherJob.getId())).isFalse();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(anotherJob.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)testDate);
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)anotherJob.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"serviceTask");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"async-continuation");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"async-after");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuationWithLongId.bpmn20.xml"})
    @Test
    public void testSuccessfulHistoricJobLogEntryStoredForLongActivityId() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().successLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualToIgnoringCase((CharSequence)"serviceTaskIdIsReallyLongAndItShouldBeMoreThan64CharsSoItWillBlowAnyActivityIdColumnWhereSizeIs64OrLessSoWeAlignItTo255LikeEverywhereElse");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testStartTimerEvent.bpmn20.xml"})
    @Test
    public void testStartTimerEventJobHandlerType() {
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"theStart");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"timer-start-event");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"CYCLE: 0 0/5 * * * ?");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testStartTimerEventInsideEventSubProcess.bpmn20.xml"})
    @Test
    public void testStartTimerEventInsideEventSubProcessJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"subprocessStartEvent");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"timer-start-event-subprocess");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"DURATION: PT1M");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testIntermediateTimerEvent.bpmn20.xml"})
    @Test
    public void testIntermediateTimerEventJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"timer");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"timer-intermediate-transition");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"DURATION: PT1M");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testBoundaryTimerEvent.bpmn20.xml"})
    @Test
    public void testBoundaryTimerEventJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"timer");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"timer-transition");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isEqualTo((Object)"DURATION: PT5M");
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)job.getDuedate());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testCatchingSignalEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testThrowingSignalEventAsync.bpmn20.xml"})
    @Test
    public void testCatchingSignalEventJobHandlerType() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isNull();
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"signalEvent");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"event");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testCatchingSignalEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testThrowingSignalEventAsync.bpmn20.xml"})
    @Test
    public void testCatchingSignalEventJobHandlerTypeDueDateSet() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(true);
        Date testDate = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((Date)historicJob.getJobDueDate()).isEqualTo((Object)testDate);
        Assertions.assertThat((String)historicJob.getJobId()).isEqualTo((Object)job.getId());
        Assertions.assertThat((String)historicJob.getJobDefinitionId()).isEqualTo((Object)job.getJobDefinitionId());
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"signalEvent");
        Assertions.assertThat((String)historicJob.getJobDefinitionType()).isEqualTo((Object)"event");
        Assertions.assertThat((String)historicJob.getJobDefinitionConfiguration()).isNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testCatchingSignalEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testThrowingSignalEventAsync.bpmn20.xml"})
    @Test
    public void testCatchingSignalEventActivityId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchSignal").getId();
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"signalEvent");
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"signalEvent");
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog().singleResult();
        Assertions.assertThat((Object)historicJob).isNotNull();
        Assertions.assertThat((String)historicJob.getActivityId()).isEqualTo((Object)"signalEvent");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testFailedJobEvents() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(0L);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(1L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.singleResult();
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(2L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(3L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(1);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(5L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(4L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(1);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(3);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(0);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testFailedJobEventsExecutedByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(0L);
        this.testRule.executeAvailableJobs();
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(3L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(1);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(5L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(4L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(1);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(3);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(0);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testSuccessfulJobEvent() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(0L);
        this.managementService.executeJob(jobId);
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(1L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        Assertions.assertThat((int)succeededJobLogEntry.getJobRetries()).isEqualTo(3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testSuccessfulJobEventExecutedByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(0L);
        this.testRule.executeAvailableJobs();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(1L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        Assertions.assertThat((int)succeededJobLogEntry.getJobRetries()).isEqualTo(3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testSuccessfulAndFailedJobEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(0L);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(0L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.singleResult();
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(2L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(0L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)failedQuery.count()).isEqualTo(2L);
        Assertions.assertThat((long)succeededQuery.count()).isEqualTo(1L);
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(3);
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        Assertions.assertThat((int)failedJobLogEntry.getJobRetries()).isEqualTo(2);
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        Assertions.assertThat((int)succeededJobLogEntry.getJobRetries()).isEqualTo(1);
    }

    @Deployment
    @Test
    public void testTerminateEndEvent() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String serviceTask1JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask1").singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        HistoricJobLogQuery serviceTask1Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId);
        HistoricJobLogQuery serviceTask1CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).creationLog();
        HistoricJobLogQuery serviceTask1DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).deletionLog();
        HistoricJobLogQuery serviceTask1SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).successLog();
        Assertions.assertThat((long)serviceTask1Query.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask1SuccessfulQuery.count()).isEqualTo(0L);
        String serviceTask2JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask2").singleResult()).getId();
        HistoricJobLogQuery serviceTask2Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId);
        HistoricJobLogQuery serviceTask2CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).creationLog();
        HistoricJobLogQuery serviceTask2DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).deletionLog();
        HistoricJobLogQuery serviceTask2SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).successLog();
        Assertions.assertThat((long)serviceTask2Query.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask2SuccessfulQuery.count()).isEqualTo(0L);
        this.managementService.executeJob(serviceTask1JobId);
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)serviceTask1Query.count()).isEqualTo(2L);
        Assertions.assertThat((long)serviceTask1CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask1SuccessfulQuery.count()).isEqualTo(1L);
        HistoricJobLog serviceTask1CreatedJobLogEntry = (HistoricJobLog)serviceTask1CreatedQuery.singleResult();
        Assertions.assertThat((int)serviceTask1CreatedJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog serviceTask1SuccessfulJobLogEntry = (HistoricJobLog)serviceTask1SuccessfulQuery.singleResult();
        Assertions.assertThat((int)serviceTask1SuccessfulJobLogEntry.getJobRetries()).isEqualTo(3);
        Assertions.assertThat((long)serviceTask2Query.count()).isEqualTo(2L);
        Assertions.assertThat((long)serviceTask2CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2DeletedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2SuccessfulQuery.count()).isEqualTo(0L);
        HistoricJobLog serviceTask2CreatedJobLogEntry = (HistoricJobLog)serviceTask2CreatedQuery.singleResult();
        Assertions.assertThat((int)serviceTask2CreatedJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog serviceTask2DeletedJobLogEntry = (HistoricJobLog)serviceTask2DeletedQuery.singleResult();
        Assertions.assertThat((int)serviceTask2DeletedJobLogEntry.getJobRetries()).isEqualTo(3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testSuperProcessWithCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testSubProcessWithErrorEndEvent.bpmn20.xml"})
    @Test
    public void testErrorEndEventInterruptingCallActivity() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        String serviceTask1JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask1").singleResult()).getId();
        HistoricJobLogQuery serviceTask1Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId);
        HistoricJobLogQuery serviceTask1CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).creationLog();
        HistoricJobLogQuery serviceTask1DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).deletionLog();
        HistoricJobLogQuery serviceTask1SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).successLog();
        Assertions.assertThat((long)serviceTask1Query.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask1SuccessfulQuery.count()).isEqualTo(0L);
        String serviceTask2JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask2").singleResult()).getId();
        HistoricJobLogQuery serviceTask2Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId);
        HistoricJobLogQuery serviceTask2CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).creationLog();
        HistoricJobLogQuery serviceTask2DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).deletionLog();
        HistoricJobLogQuery serviceTask2SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).successLog();
        Assertions.assertThat((long)serviceTask2Query.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask2SuccessfulQuery.count()).isEqualTo(0L);
        this.managementService.executeJob(serviceTask1JobId);
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)serviceTask1Query.count()).isEqualTo(2L);
        Assertions.assertThat((long)serviceTask1CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask1DeletedQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)serviceTask1SuccessfulQuery.count()).isEqualTo(1L);
        HistoricJobLog serviceTask1CreatedJobLogEntry = (HistoricJobLog)serviceTask1CreatedQuery.singleResult();
        Assertions.assertThat((int)serviceTask1CreatedJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog serviceTask1SuccessfulJobLogEntry = (HistoricJobLog)serviceTask1SuccessfulQuery.singleResult();
        Assertions.assertThat((int)serviceTask1SuccessfulJobLogEntry.getJobRetries()).isEqualTo(3);
        Assertions.assertThat((long)serviceTask2Query.count()).isEqualTo(2L);
        Assertions.assertThat((long)serviceTask2CreatedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2DeletedQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)serviceTask2SuccessfulQuery.count()).isEqualTo(0L);
        HistoricJobLog serviceTask2CreatedJobLogEntry = (HistoricJobLog)serviceTask2CreatedQuery.singleResult();
        Assertions.assertThat((int)serviceTask2CreatedJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog serviceTask2DeletedJobLogEntry = (HistoricJobLog)serviceTask2DeletedQuery.singleResult();
        Assertions.assertThat((int)serviceTask2DeletedJobLogEntry.getJobRetries()).isEqualTo(3);
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testDeletedJob() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery deletedQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).deletionLog();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)deletedQuery.count()).isEqualTo(0L);
        this.managementService.deleteJob(jobId);
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)deletedQuery.count()).isEqualTo(1L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog deletedJobLogEntry = (HistoricJobLog)deletedQuery.singleResult();
        Assertions.assertThat((int)deletedJobLogEntry.getJobRetries()).isEqualTo(3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testDeletedProcessInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery deletedQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).deletionLog();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)deletedQuery.count()).isEqualTo(0L);
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)createdQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)deletedQuery.count()).isEqualTo(1L);
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        Assertions.assertThat((int)createdJobLogEntry.getJobRetries()).isEqualTo(3);
        HistoricJobLog deletedJobLogEntry = (HistoricJobLog)deletedQuery.singleResult();
        Assertions.assertThat((int)deletedJobLogEntry.getJobRetries()).isEqualTo(3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    @Test
    public void testExceptionStacktrace() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String failedHistoricJobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult()).getId();
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(failedHistoricJobLogId);
        Assertions.assertThat((String)stacktrace).isNotNull();
        Assertions.assertThat((String)stacktrace).containsIgnoringCase((CharSequence)"Expected_exception.");
    }

    @Test
    public void shouldGetJobExceptionStacktraceUnexistingJobId() {
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace("unexistingjob");
            Assertions.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            Assertions.assertThat((String)re.getMessage()).containsIgnoringCase((CharSequence)"No historic job log found with id unexistingjob");
        }
    }

    @Test
    public void shouldGetJobExceptionStacktraceNullJobId() {
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace(null);
            Assertions.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            Assertions.assertThat((String)re.getMessage()).containsIgnoringCase((CharSequence)"historicJobLogId is null");
        }
    }

    @Deployment
    @Test
    public void testDifferentExceptions() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog serviceTask1FailedHistoricJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String serviceTask1FailedHistoricJobLogId = serviceTask1FailedHistoricJobLog.getId();
        Assertions.assertThat((String)serviceTask1FailedHistoricJobLog.getJobExceptionMessage()).isEqualTo((Object)"First expected exception.");
        String serviceTask1Stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(serviceTask1FailedHistoricJobLogId);
        Assertions.assertThat((String)serviceTask1Stacktrace).isNotNull();
        Assertions.assertThat((String)serviceTask1Stacktrace).containsIgnoringCase((CharSequence)"First expected exception.");
        Assertions.assertThat((String)serviceTask1Stacktrace).containsIgnoringCase((CharSequence)FirstFailingDelegate.class.getName());
        this.runtimeService.setVariable(processInstanceId, "firstFail", (Object)false);
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog serviceTask2FailedHistoricJobLog = (HistoricJobLog)((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().failureLog().orderByJobRetries().desc()).list().get(1);
        String serviceTask2FailedHistoricJobLogId = serviceTask2FailedHistoricJobLog.getId();
        Assertions.assertThat((String)serviceTask2FailedHistoricJobLog.getJobExceptionMessage()).isEqualTo((Object)"Second expected exception.");
        String serviceTask2Stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(serviceTask2FailedHistoricJobLogId);
        Assertions.assertThat((String)serviceTask2Stacktrace).isNotNull();
        Assertions.assertThat((String)serviceTask2Stacktrace).containsIgnoringCase((CharSequence)"Second expected exception.");
        Assertions.assertThat((String)serviceTask2Stacktrace).containsIgnoringCase((CharSequence)SecondFailingDelegate.class.getName());
        Assertions.assertThat((boolean)serviceTask1Stacktrace.equals(serviceTask2Stacktrace)).isFalse();
    }

    @Deployment
    @Test
    public void testThrowExceptionWithoutMessage() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog failedHistoricJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String failedHistoricJobLogId = failedHistoricJobLog.getId();
        Assertions.assertThat((String)failedHistoricJobLog.getJobExceptionMessage()).isNull();
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(failedHistoricJobLogId);
        Assertions.assertThat((String)stacktrace).isNotNull();
        Assertions.assertThat((String)stacktrace).containsIgnoringCase((CharSequence)ThrowExceptionWithoutMessageDelegate.class.getName());
    }

    @Deployment
    @Test
    public void testThrowExceptionMessageTruncation() {
        String exceptionMessage = new BigInteger(10000, new Random()).toString(2);
        ThrowExceptionWithOverlongMessageDelegate delegate = new ThrowExceptionWithOverlongMessageDelegate(exceptionMessage);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("delegate", (Object)delegate));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            Assertions.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog failedHistoricJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        Assertions.assertThat((Object)failedHistoricJobLog).isNotNull();
        Assertions.assertThat((String)failedHistoricJobLog.getJobExceptionMessage()).isEqualToIgnoringCase((CharSequence)exceptionMessage.substring(0, StringUtil.DB_MAX_STRING_LENGTH));
    }

    @Test
    public void testAsyncAfterJobDefinitionAfterEngineRestart() {
        BpmnModelInstance modelInstance = ((ManualTaskBuilder)((ManualTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().camundaAsyncBefore()).camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(modelInstance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinition asyncBeforeJobDef = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-before").singleResult();
        JobDefinition asyncAfterJobDef = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-after").singleResult();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        deploymentCache.removeProcessDefinition(processInstance.getProcessDefinitionId());
        Job asyncBeforeJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(asyncBeforeJob.getId());
        Job asyncAfterJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(asyncAfterJob.getId());
        Assertions.assertThat((String)asyncBeforeJob.getJobDefinitionId()).isEqualTo((Object)asyncBeforeJobDef.getId());
        Assertions.assertThat((String)asyncAfterJob.getJobDefinitionId()).isEqualTo((Object)asyncAfterJobDef.getId());
        HistoricJobLog asyncBeforeLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().creationLog().jobId(asyncBeforeJob.getId()).singleResult();
        Assertions.assertThat((String)asyncBeforeLog.getJobDefinitionId()).isEqualTo((Object)asyncBeforeJobDef.getId());
        HistoricJobLog asyncAfterLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().creationLog().jobId(asyncAfterJob.getId()).singleResult();
        Assertions.assertThat((String)asyncAfterLog.getJobDefinitionId()).isEqualTo((Object)asyncAfterJobDef.getId());
    }

    @Test
    public void testDeleteByteArray() {
        String processDefinitionId = "myProcessDefition";
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute(commandContext -> {
            for (int i = 0; i < 1234; ++i) {
                HistoricJobLogEventEntity log = new HistoricJobLogEventEntity();
                log.setJobId(String.valueOf(i));
                log.setTimestamp(new Date());
                log.setJobDefinitionType("message");
                log.setProcessDefinitionId("myProcessDefition");
                byte[] aByteValue = StringUtil.toByteArray((String)"abc");
                ByteArrayEntity byteArray = ExceptionUtil.createJobExceptionByteArray((byte[])aByteValue, (ResourceType)ResourceTypes.HISTORY);
                log.setExceptionByteArrayId(byteArray.getId());
                commandContext.getHistoricJobLogManager().insert((DbEntity)log);
            }
            return null;
        });
        Assertions.assertThat((long)this.historyService.createHistoricJobLogQuery().count()).isEqualTo(1234L);
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute(commandContext -> {
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByProcessDefinitionId("myProcessDefition");
            return null;
        });
        Assertions.assertThat((long)this.historyService.createHistoricJobLogQuery().count()).isEqualTo(0L);
    }
}

