/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricTaskInstanceTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testHistoricTaskInstance() throws Exception {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        Task runtimeTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        runtimeTask.setPriority(1234);
        Date dueDate = sdf.parse("01/02/2003 04:05:06");
        runtimeTask.setDueDate(dueDate);
        this.taskService.saveTask(runtimeTask);
        String taskId = runtimeTask.getId();
        String taskDefinitionKey = runtimeTask.getTaskDefinitionKey();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)taskId, (Object)historicTaskInstance.getId());
        Assert.assertEquals((long)1234L, (long)historicTaskInstance.getPriority());
        Assert.assertEquals((Object)"Clean up", (Object)historicTaskInstance.getName());
        Assert.assertEquals((Object)"Schedule an engineering meeting for next week with the new hire.", (Object)historicTaskInstance.getDescription());
        Assert.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
        Assert.assertEquals((Object)"kermit", (Object)historicTaskInstance.getAssignee());
        Assert.assertEquals((Object)taskDefinitionKey, (Object)historicTaskInstance.getTaskDefinitionKey());
        Assert.assertNull((Object)historicTaskInstance.getEndTime());
        Assert.assertNull((Object)historicTaskInstance.getDurationInMillis());
        Assert.assertNull((Object)historicTaskInstance.getCaseDefinitionId());
        Assert.assertNull((Object)historicTaskInstance.getCaseInstanceId());
        Assert.assertNull((Object)historicTaskInstance.getCaseExecutionId());
        Assert.assertEquals((Object)"Updated", (Object)historicTaskInstance.getTaskState());
        Assert.assertEquals((Object)((TaskEntity)runtimeTask).getExecution().getActivityInstanceId(), (Object)historicTaskInstance.getActivityInstanceId());
        this.runtimeService.setVariable(processInstanceId, "deadline", (Object)"yesterday");
        Date now = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 1000L));
        this.taskService.complete(taskId);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)taskId, (Object)historicTaskInstance.getId());
        Assert.assertEquals((long)1234L, (long)historicTaskInstance.getPriority());
        Assert.assertEquals((Object)"Clean up", (Object)historicTaskInstance.getName());
        Assert.assertEquals((Object)"Schedule an engineering meeting for next week with the new hire.", (Object)historicTaskInstance.getDescription());
        Assert.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
        Assert.assertEquals((Object)"kermit", (Object)historicTaskInstance.getAssignee());
        Assert.assertEquals((Object)"completed", (Object)historicTaskInstance.getDeleteReason());
        Assert.assertEquals((Object)taskDefinitionKey, (Object)historicTaskInstance.getTaskDefinitionKey());
        Assert.assertNotNull((Object)historicTaskInstance.getEndTime());
        Assert.assertNotNull((Object)historicTaskInstance.getDurationInMillis());
        Assert.assertTrue((historicTaskInstance.getDurationInMillis() >= 1000L ? 1 : 0) != 0);
        Assert.assertTrue((((HistoricTaskInstanceEntity)historicTaskInstance).getDurationRaw() >= 1000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Completed", (Object)historicTaskInstance.getTaskState());
        Assert.assertNull((Object)historicTaskInstance.getCaseDefinitionId());
        Assert.assertNull((Object)historicTaskInstance.getCaseInstanceId());
        Assert.assertNull((Object)historicTaskInstance.getCaseExecutionId());
        this.historyService.deleteHistoricTaskInstance(taskId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
    }

    @Test
    public void testDeleteHistoricTaskInstance() {
        this.historyService.deleteHistoricTaskInstance("unexistingId");
    }

    @Deployment
    @Test
    public void testHistoricTaskInstanceQuery() throws Exception {
        ProcessInstance finishedInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(finishedInstance.getId()).singleResult();
        task.setPriority(1234);
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId("unexistingtaskid").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskName("Clean_up").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskName("unexistingname").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("Clean\\_u%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%lean\\_up").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%lean\\_u%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskNameLike("%unexistingname%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescription("Historic task_description").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescription("unexistingdescription").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%task\\_description").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("Historic task%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%task%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("%unexistingdescripton%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().executionId(finishedInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().executionId("unexistingexecution").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(finishedInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId("unexistingid").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(finishedInstance.getProcessDefinitionId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId("unexistingdefinitionid").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionName("Historic task query test process").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionName("unexistingdefinitionname").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey("HistoricTaskQueryTest").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey("unexistingdefinitionkey").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssignee("ker_mit").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssignee("johndoe").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%er\\_mit").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("ker\\_mi%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%er\\_mi%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskAssigneeLike("%johndoe%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDeleteReason("completed").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDeleteReason("deleted").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKey("task").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKey("unexistingkey").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskPriority(Integer.valueOf(1234)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskPriority(Integer.valueOf(5678)).count());
        Calendar anHourAgo = Calendar.getInstance();
        anHourAgo.setTime(dueDate);
        anHourAgo.add(10, -1);
        Calendar anHourLater = Calendar.getInstance();
        anHourLater.setTime(dueDate);
        anHourLater.add(10, 1);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(anHourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(anHourLater.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueAfter(anHourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueAfter(anHourLater.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueBefore(anHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueBefore(anHourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueAfter(anHourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueDate(dueDate).taskDueAfter(anHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskDueBefore(anHourAgo.getTime()).taskDueAfter(anHourLater.getTime()).count());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().startedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().startedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().startedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().startedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).count());
        this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().finished().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().unfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().unfinished().finished().count());
    }

    @Deployment
    @Test
    public void testHistoricTaskInstanceQueryByProcessVariableValue() throws Exception {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("hallo", "steffen");
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", variables).getId();
            Task runtimeTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            String taskId = runtimeTask.getId();
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("hallo", (Object)"steffen").singleResult();
            Assert.assertNotNull((Object)historicTaskInstance);
            Assert.assertEquals((Object)taskId, (Object)historicTaskInstance.getId());
            this.taskService.complete(taskId);
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).count());
            this.historyService.deleteHistoricTaskInstance(taskId);
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        }
    }

    @Test
    public void testHistoricTaskInstanceAssignment() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertNull((Object)hti.getAssignee());
        Assert.assertEquals((Object)"Created", (Object)hti.getTaskState());
        this.taskService.setAssignee(task.getId(), "jonny");
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)"jonny", (Object)hti.getAssignee());
        Assert.assertNull((Object)hti.getOwner());
        Assert.assertEquals((Object)"Updated", (Object)hti.getTaskState());
        this.taskService.deleteTask(task.getId());
        HistoricTaskInstance htiDeleted = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"Deleted", (Object)htiDeleted.getTaskState());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    @Deployment
    @Test
    public void testHistoricTaskInstanceAssignmentListener() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "jonny");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        HistoricActivityInstance hai = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult();
        Assert.assertEquals((Object)"jonny", (Object)hai.getAssignee());
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)"jonny", (Object)hti.getAssignee());
        Assert.assertNull((Object)hti.getOwner());
    }

    @Test
    public void testHistoricTaskInstanceOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertNull((Object)hti.getOwner());
        this.taskService.setOwner(task.getId(), "jonny");
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)"jonny", (Object)hti.getOwner());
        this.taskService.deleteTask(task.getId());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    @Test
    public void testHistoricTaskInstancePriority() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((long)50L, (long)hti.getPriority());
        this.taskService.setPriority(task.getId(), 100);
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((long)100L, (long)hti.getPriority());
        this.taskService.deleteTask(task.getId());
        this.historyService.deleteHistoricTaskInstance(hti.getId());
    }

    @Deployment
    @Test
    public void testHistoricTaskInstanceQueryProcessFinished() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("TwoTaskHistoricTaskQueryTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processFinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processUnfinished().processFinished().count());
    }

    @Deployment
    @Test
    public void testHistoricTaskInstanceQuerySorting() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("HistoricTaskQueryTest");
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(instance.getId()).singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDueDate().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskFollowUpDate().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseDefinitionId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseInstanceId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseExecutionId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDueDate().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskFollowUpDate().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseDefinitionId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseInstanceId().desc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByCaseExecutionId().desc()).count());
    }

    @Test
    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricTaskInstanceQuery().asc();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricTaskInstanceQuery().desc();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    @Test
    public void testHistoricTaskInstanceQueryByFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        Assert.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(otherDate.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).taskFollowUpDate(followUpDate).count());
        otherDate.add(1, -2);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpAfter(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).count());
        Assert.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpBefore(otherDate.getTime()).taskFollowUpDate(followUpDate).count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)followUpDate, (Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskFollowUpDate(followUpDate).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    @Test
    public void testHistoricTaskInstanceQueryByActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId});
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    @Test
    public void testHistoricTaskInstanceQueryByActivityInstanceIds() throws Exception {
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        String activityInstanceId1 = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi1.getId()).activityId("task").singleResult()).getId();
        String activityInstanceId2 = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi2.getId()).activityId("task").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2});
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testHistoricTaskInstance.bpmn20.xml"})
    @Test
    public void testHistoricTaskInstanceQueryByInvalidActivityInstanceId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.activityInstanceIdIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.activityInstanceIdIn(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.activityInstanceIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.activityInstanceIdIn(values);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionId(caseDefinitionId);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)task.getCaseExecutionId());
    }

    @Test
    public void testQueryByInvalidCaseDefinitionId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
        query.caseDefinitionId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionKey() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionKey(key);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)task.getCaseExecutionId());
    }

    @Test
    public void testQueryByInvalidCaseDefinitionKey() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionKey("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
        query.caseDefinitionKey(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionName() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseDefinitionName = caseDefinition.getName();
        String caseDefinitionId = caseDefinition.getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionName(caseDefinitionName);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)task.getCaseExecutionId());
    }

    @Test
    public void testQueryByInvalidCaseDefinitionName() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseDefinitionName("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
        query.caseDefinitionName(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseInstanceId() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)task.getCaseExecutionId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testQueryByCaseInstanceIdHierarchy.cmmn", "org/eximeebpms/bpm/engine/test/history/HistoricTaskInstanceTest.testQueryByCaseInstanceIdHierarchy.bpmn20.xml"})
    @Test
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        for (HistoricTaskInstance task : query.list()) {
            Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
            Assert.assertNull((Object)task.getCaseDefinitionId());
            Assert.assertNull((Object)task.getCaseExecutionId());
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        for (HistoricTaskInstance task : query.list()) {
            Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
            Assert.assertNull((Object)task.getCaseDefinitionId());
            Assert.assertNull((Object)task.getCaseExecutionId());
        }
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseExecutionId() {
        String key = "oneTaskCase";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinitionByKey(key).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseExecutionId(humanTaskId);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        HistoricTaskInstance task = (HistoricTaskInstance)query.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)task.getCaseExecutionId());
    }

    @Test
    public void testQueryByInvalidCaseExecutionId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.caseExecutionId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
        query.caseExecutionId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Test
    public void testHistoricTaskInstanceCaseInstanceId() {
        Task task = this.taskService.newTask();
        task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(task);
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)hti.getCaseInstanceId());
        task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(task);
        hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"anotherCaseInstanceId", (Object)hti.getCaseInstanceId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).taskDefinitionKey("theTask").singleResult();
        Assert.assertNotNull((Object)task.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)task.getProcessDefinitionKey());
        Assert.assertNull((Object)task.getCaseDefinitionKey());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseDefinitionKeyProperty() {
        String key = "oneTaskCase";
        String caseInstanceId = this.caseService.createCaseInstanceByKey(key).getId();
        HistoricTaskInstance task = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().caseInstanceId(caseInstanceId).taskDefinitionKey("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)task.getCaseDefinitionKey());
        Assert.assertEquals((Object)key, (Object)task.getCaseDefinitionKey());
        Assert.assertNull((Object)task.getProcessDefinitionKey());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByTaskDefinitionKey() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricTaskInstanceQuery query1 = this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKey("theTask");
        HistoricTaskInstanceQuery query2 = this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKeyIn(new String[]{"theTask"});
        Assert.assertEquals((long)1L, (long)query1.count());
        Assert.assertEquals((long)1L, (long)query2.count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByTaskDefinitionKeys() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKeyIn(new String[]{"theTask", "PI_HumanTask_1"});
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidTaskDefinitionKeys() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.taskDefinitionKeyIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.taskDefinitionKeyIn(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            query.taskDefinitionKeyIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.taskDefinitionKeyIn(values);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceBusinessKey() {
        ProcessInstance piBusinessKey1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKey(piBusinessKey1.getBusinessKey()).count());
        Assert.assertEquals((long)0L, (long)query.processInstanceBusinessKey("unexistingBusinessKey").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceBusinessKeyIn() {
        String businessKey1 = "BUSINESS-KEY-1";
        String businessKey2 = "BUSINESS-KEY-2";
        String businessKey3 = "BUSINESS-KEY-3";
        String unexistingBusinessKey = "unexistingBusinessKey";
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey2);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey3);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)3L, (long)query.processInstanceBusinessKeyIn(new String[]{businessKey1, businessKey2, businessKey3}).list().size());
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyIn(new String[]{businessKey2, unexistingBusinessKey}).count());
    }

    @Test
    public void testQueryByInvalidProcessInstanceBusinessKeyIn() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        query.processInstanceBusinessKeyIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.processInstanceBusinessKeyIn(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.processInstanceBusinessKeyIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.processInstanceBusinessKeyIn(values);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceBusinessKeyLike() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyLike("BUSINESS-KEY-1").list().size());
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyLike("BUSINESS-KEY%").count());
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyLike("%KEY-1").count());
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyLike("%KEY%").count());
        Assert.assertEquals((long)0L, (long)query.processInstanceBusinessKeyLike("BUZINESS-KEY%").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceBusinessKeyAndArray() {
        String businessKey1 = "BUSINESS-KEY-1";
        String businessKey2 = "BUSINESS-KEY-2";
        String businessKey3 = "BUSINESS-KEY-3";
        String unexistingBusinessKey = "unexistingBusinessKey";
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey2);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", businessKey3);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.processInstanceBusinessKeyIn(new String[]{businessKey1, businessKey2}).processInstanceBusinessKey(unexistingBusinessKey).count());
        Assert.assertEquals((long)1L, (long)query.processInstanceBusinessKeyIn(new String[]{businessKey2, businessKey3}).processInstanceBusinessKey(businessKey2).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/history/multiprocess/rootProcess.bpmn", "org/eximeebpms/bpm/engine/test/api/history/multiprocess/secondLevelProcess.bpmn", "org/eximeebpms/bpm/engine/test/api/history/multiprocess/thirdLevelProcess.bpmn"})
    @Test
    public void testQueryByRootProcessInstanceId() {
        String rootProcessId = this.runtimeService.startProcessInstanceByKey("root-process").getId();
        this.runtimeService.startProcessInstanceByKey("process-3");
        while (this.historyService.createHistoricProcessInstanceQuery().unfinished().count() > 0L) {
            this.taskService.createTaskQuery().list().forEach(task -> this.taskService.complete(task.getId()));
        }
        List allTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery().rootProcessInstanceId(rootProcessId);
        Assert.assertEquals((long)8L, (long)allTaskInstances.size());
        Assert.assertEquals((long)6L, (long)allTaskInstances.stream().filter(task -> task.getRootProcessInstanceId().equals(rootProcessId)).count());
        Assert.assertEquals((long)6L, (long)historicTaskInstanceQuery.count());
        Assert.assertEquals((long)6L, (long)historicTaskInstanceQuery.list().size());
    }
}

