/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.dmn;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.history.DecisionServiceDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ResetDmnConfigUtil;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceDecisionServiceEvaluationTest {
    protected static final String DECISION_PROCESS_WITH_DECISION_SERVICE = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegation.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_START_LISTENER = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideStartListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_END_LISTENER = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideEndListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_TAKE_LISTENER = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideTakeListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_INSIDE_EXPRESSION = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideExpression.bpmn20.xml";
    protected static final String DECISION_PROCESS_INSIDE_DELEGATE_EXPRESSION = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegateExpression.bpmn20.xml";
    protected static final String DECISION_DMN = "org/eximeebpms/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";
    @Parameterized.Parameter(value=0)
    public String process;
    @Parameterized.Parameter(value=1)
    public String activityId;
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({DECISION_PROCESS_WITH_DECISION_SERVICE, "task"}, {DECISION_PROCESS_WITH_START_LISTENER, "task"}, {DECISION_PROCESS_WITH_END_LISTENER, "task"}, {DECISION_PROCESS_INSIDE_EXPRESSION, "task"}, {DECISION_PROCESS_INSIDE_DELEGATE_EXPRESSION, "task"}, {DECISION_PROCESS_WITH_TAKE_LISTENER, "start"});
    }

    @Before
    public void init() {
        this.testRule.deploy(DECISION_DMN, this.process);
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void enableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void disableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Test
    public void evaluateDecisionWithDecisionService() {
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("input1", null).putValue("myBean", (Object)new DecisionServiceDelegate()));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isEqualTo((Object)processDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)this.activityId);
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }
}

