/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.useroperationlog;

import java.util.Arrays;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LegacyUserOperationLogTest {
    public static final String USER_ID = "demo";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/history/useroperationlog/enable.legacy.user.operation.log.eximeebpms.cfg.xml");
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.processEngineRule).around((TestRule)this.testHelper);
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected Batch batch;

    @Before
    public void initServices() {
        this.identityService = this.processEngineRule.getIdentityService();
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.historyService = this.processEngineRule.getHistoryService();
        this.managementService = this.processEngineRule.getManagementService();
    }

    @After
    public void removeBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogAllOperationWithAuthentication() {
        try {
            this.identityService.setAuthenticatedUserId(USER_ID);
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
            Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "taskListenerCalled")));
            Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "serviceTaskCalled")));
            UserOperationLogQuery query = this.userOperationLogQuery().userId(USER_ID);
            Assert.assertEquals((long)4L, (long)query.count());
            Assert.assertEquals((long)1L, (long)query.operationType("Create").count());
            Assert.assertEquals((long)1L, (long)query.operationType("Complete").count());
            Assert.assertEquals((long)2L, (long)query.operationType("SetVariable").count());
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogOperationWithoutAuthentication() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "taskListenerCalled")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "serviceTaskCalled")));
        Assert.assertEquals((long)5L, (long)this.userOperationLogQuery().count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("Complete").count());
        Assert.assertEquals((long)2L, (long)this.userOperationLogQuery().operationType("SetVariable").count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().entityType("Deployment").operationType("Create").count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().entityType("ProcessInstance").operationType("Create").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/useroperationlog/UserOperationLogTaskTest.testOnlyTaskCompletionIsLogged.bpmn20.xml"})
    public void testLogSetVariableWithoutAuthentication() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"aValue");
        Assert.assertEquals((long)3L, (long)this.userOperationLogQuery().count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("SetVariable").count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().entityType("Deployment").operationType("Create").count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().entityType("ProcessInstance").operationType("Create").count());
    }

    @Test
    public void testDontWriteDuplicateLogOnBatchDeletionJobExecution() {
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(definition.getId());
        this.batch = this.runtimeService.deleteProcessInstancesAsync(Arrays.asList(processInstance.getId()), null, "test reason");
        Job seedJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(seedJob.getId());
        for (Job pending : this.managementService.createJobQuery().list()) {
            this.managementService.executeJob(pending.getId());
        }
        Assert.assertEquals((long)5L, (long)this.userOperationLogQuery().entityTypeIn(new String[]{"ProcessInstance", "Deployment"}).count());
    }

    @Test
    public void testDontWriteDuplicateLogOnBatchMigrationJobExecution() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        Job seedJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(seedJob.getId());
        Job migrationJob = (Job)this.managementService.createJobQuery().jobDefinitionId(this.batch.getBatchJobDefinitionId()).singleResult();
        this.managementService.executeJob(migrationJob.getId());
        Assert.assertEquals((long)9L, (long)this.userOperationLogQuery().count());
        Assert.assertEquals((long)2L, (long)this.userOperationLogQuery().operationType("Create").entityType("Deployment").count());
        Assert.assertEquals((long)1L, (long)this.userOperationLogQuery().operationType("Create").entityType("ProcessInstance").count());
        Assert.assertEquals((long)3L, (long)this.userOperationLogQuery().operationType("Migrate").entityType("ProcessInstance").count());
    }

    protected UserOperationLogQuery userOperationLogQuery() {
        return this.historyService.createUserOperationLogQuery();
    }
}

